/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.core.Quad;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.Prologue;
import org.apache.jena.riot.system.RiotChars;

public class NodeFmtLib {
    private static final NodeFormatter plainFormatter = new NodeFormatterNT();
    private static PrefixMap dftPrefixMap = PrefixMapFactory.create();
    static char encodeMarkerChar;
    private static char LabelLeadingLetter;
    private static int relFlags;

    public static String str(Triple t) {
        return NodeFmtLib.strNodes(t.getSubject(), t.getPredicate(), t.getObject());
    }

    public static String str(Quad q) {
        return NodeFmtLib.strNodes(q.getGraph(), q.getSubject(), q.getPredicate(), q.getObject());
    }

    public static String str(Node n) {
        IndentedLineBuffer sw = new IndentedLineBuffer();
        NodeFmtLib.str(sw, n);
        return sw.toString();
    }

    public static String displayStr(RDFNode obj) {
        return NodeFmtLib.displayStr(obj.asNode());
    }

    public static String displayStr(Node n) {
        return NodeFmtLib.str(n, null, dftPrefixMap);
    }

    public static String strNodes(Node ... nodes) {
        IndentedLineBuffer sw = new IndentedLineBuffer();
        boolean first = true;
        for (Node n : nodes) {
            if (!first) {
                sw.append(" ", new Object[0]);
            }
            first = false;
            NodeFmtLib.str(sw, n);
        }
        return sw.toString();
    }

    public static void str(IndentedWriter w, Node n) {
        NodeFmtLib.serialize(w, n, null, null);
    }

    public static String str(Node n, Prologue prologue) {
        return NodeFmtLib.str(n, prologue.getBaseURI(), prologue.getPrefixMap());
    }

    public static String str(Node n, String base, PrefixMap prefixMap) {
        IndentedLineBuffer sw = new IndentedLineBuffer();
        NodeFmtLib.serialize(sw, n, base, prefixMap);
        return sw.toString();
    }

    public static void serialize(IndentedWriter w, Node n, Prologue prologue) {
        NodeFmtLib.serialize(w, n, prologue.getBaseURI(), prologue.getPrefixMap());
    }

    public static void serialize(IndentedWriter w, Node n, String base, PrefixMap prefixMap) {
        NodeFormatter formatter = base == null && prefixMap == null ? plainFormatter : new NodeFormatterTTL(base, prefixMap);
        formatter.format(w, n);
    }

    public static String encodeBNodeLabel(String label) {
        StringBuilder buff = new StringBuilder();
        buff.append(LabelLeadingLetter);
        for (int i2 = 0; i2 < label.length(); ++i2) {
            char ch = label.charAt(i2);
            if (ch == encodeMarkerChar) {
                buff.append(ch);
                buff.append(ch);
                continue;
            }
            if (RiotChars.isA2ZN(ch)) {
                buff.append(ch);
                continue;
            }
            Chars.encodeAsHex(buff, encodeMarkerChar, ch);
        }
        return buff.toString();
    }

    public static String decodeBNodeLabel(String label) {
        StringBuilder buffer = new StringBuilder();
        if (label.charAt(0) != LabelLeadingLetter) {
            return label;
        }
        for (int i2 = 1; i2 < label.length(); ++i2) {
            char ch = label.charAt(i2);
            if (ch != encodeMarkerChar) {
                buffer.append(ch);
                continue;
            }
            char ch2 = label.charAt(i2 + 1);
            if (ch2 == encodeMarkerChar) {
                ++i2;
                buffer.append(ch);
                continue;
            }
            char hiC = label.charAt(++i2);
            int hi = Bytes.hexCharToInt(hiC);
            char loC = label.charAt(++i2);
            int lo = Bytes.hexCharToInt(loC);
            int combined = hi << 4 | lo;
            buffer.append((char)combined);
        }
        return buffer.toString();
    }

    public static String abbrevByBase(String uri, String base) {
        if (base == null) {
            return null;
        }
        IRI baseIRI = IRIFactory.jenaImplementation().construct(base);
        IRI rel = baseIRI.relativize(uri, relFlags);
        String r = null;
        try {
            r = rel.toASCIIString();
        }
        catch (MalformedURLException ex) {
            r = rel.toString();
        }
        return r;
    }

    static {
        PrefixMapping pm = ARQConstants.getGlobalPrefixMap();
        Map<String, String> map = pm.getNsPrefixMap();
        for (Map.Entry<String, String> e2 : map.entrySet()) {
            dftPrefixMap.add(e2.getKey(), e2.getValue());
        }
        encodeMarkerChar = (char)88;
        LabelLeadingLetter = (char)66;
        relFlags = 9;
    }
}

