/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import com.hp.hpl.jena.shared.PrefixMapping;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.ActionKeyValue;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.riot.system.PrefixMap;

public abstract class PrefixMapBase
implements PrefixMap {
    protected boolean strSafeFor(String str2, char ch) {
        return str2.indexOf(ch) == -1;
    }

    protected String canonicalPrefix(String prefix) {
        if (prefix.endsWith(":")) {
            return prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    @Override
    public Map<String, IRI> getMappingCopy() {
        return new HashMap<String, IRI>(this.getMapping());
    }

    @Override
    public Map<String, String> getMappingCopyStr() {
        final HashMap<String, String> smap = new HashMap<String, String>();
        ActionKeyValue<String, IRI> action = new ActionKeyValue<String, IRI>(){

            @Override
            public void apply(String key, IRI value) {
                String str2 = value.toString();
                smap.put(key, str2);
            }
        };
        Iter.apply(this.getMapping(), action);
        return smap;
    }

    @Override
    public void add(String prefix, String iriString) {
        this.add(prefix, IRIFactory.iriImplementation().create(iriString));
    }

    @Override
    public void putAll(PrefixMap pmap) {
        for (Map.Entry<String, IRI> e2 : pmap.getMapping().entrySet()) {
            this.add(e2.getKey(), e2.getValue());
        }
    }

    @Override
    public void putAll(PrefixMapping pmap) {
        this.putAll(pmap.getNsPrefixMap());
    }

    @Override
    public void putAll(Map<String, String> mapping) {
        for (Map.Entry<String, String> e2 : mapping.entrySet()) {
            this.add(e2.getKey(), e2.getValue());
        }
    }

    protected Pair<String, String> abbrev(Map<String, IRI> prefixes, String uriStr, boolean checkLocalPart) {
        for (Map.Entry<String, IRI> e2 : prefixes.entrySet()) {
            String uriForPrefix = e2.getValue().toString();
            if (!uriStr.startsWith(uriForPrefix)) continue;
            String ln = uriStr.substring(uriForPrefix.length());
            if (checkLocalPart && !this.isSafeLocalPart(ln)) continue;
            return Pair.create(e2.getKey(), ln);
        }
        return null;
    }

    @Override
    public String expand(String prefixedName) {
        int i2 = prefixedName.indexOf(58);
        if (i2 < 0) {
            return null;
        }
        return this.expand(prefixedName.substring(0, i2), prefixedName.substring(i2 + 1));
    }

    protected boolean isSafeLocalPart(String ln) {
        return this.strSafeFor(ln, '/') && this.strSafeFor(ln, '#') && this.strSafeFor(ln, ':');
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        boolean first = true;
        for (Map.Entry<String, IRI> e2 : this.getMapping().entrySet()) {
            String prefix = e2.getKey();
            IRI iri2 = e2.getValue();
            if (first) {
                first = false;
            } else {
                sb.append(" ,");
            }
            sb.append(prefix);
            sb.append(":=");
            sb.append(iri2.toString());
        }
        sb.append(" }");
        return sb.toString();
    }
}

