/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hu;

import org.apache.lucene.analysis.util.StemmerUtil;

public class HungarianLightStemmer {
    public int stem(char[] s2, int len) {
        block7: for (int i2 = 0; i2 < len; ++i2) {
            switch (s2[i2]) {
                case '\u00e1': {
                    s2[i2] = 97;
                    continue block7;
                }
                case '\u00e9': 
                case '\u00eb': {
                    s2[i2] = 101;
                    continue block7;
                }
                case '\u00ed': {
                    s2[i2] = 105;
                    continue block7;
                }
                case '\u00f3': 
                case '\u00f5': 
                case '\u00f6': 
                case '\u0151': {
                    s2[i2] = 111;
                    continue block7;
                }
                case '\u00fa': 
                case '\u00fb': 
                case '\u00fc': 
                case '\u0169': 
                case '\u0171': {
                    s2[i2] = 117;
                }
            }
        }
        len = this.removeCase(s2, len);
        len = this.removePossessive(s2, len);
        len = this.removePlural(s2, len);
        return this.normalize(s2, len);
    }

    private int removeCase(char[] s2, int len) {
        if (len > 6 && StemmerUtil.endsWith(s2, len, "kent")) {
            return len - 4;
        }
        if (len > 5) {
            if (StemmerUtil.endsWith(s2, len, "nak") || StemmerUtil.endsWith(s2, len, "nek") || StemmerUtil.endsWith(s2, len, "val") || StemmerUtil.endsWith(s2, len, "vel") || StemmerUtil.endsWith(s2, len, "ert") || StemmerUtil.endsWith(s2, len, "rol") || StemmerUtil.endsWith(s2, len, "ban") || StemmerUtil.endsWith(s2, len, "ben") || StemmerUtil.endsWith(s2, len, "bol") || StemmerUtil.endsWith(s2, len, "nal") || StemmerUtil.endsWith(s2, len, "nel") || StemmerUtil.endsWith(s2, len, "hoz") || StemmerUtil.endsWith(s2, len, "hez") || StemmerUtil.endsWith(s2, len, "tol")) {
                return len - 3;
            }
            if ((StemmerUtil.endsWith(s2, len, "al") || StemmerUtil.endsWith(s2, len, "el")) && !this.isVowel(s2[len - 3]) && s2[len - 3] == s2[len - 4]) {
                return len - 3;
            }
        }
        if (len > 4) {
            if (StemmerUtil.endsWith(s2, len, "at") || StemmerUtil.endsWith(s2, len, "et") || StemmerUtil.endsWith(s2, len, "ot") || StemmerUtil.endsWith(s2, len, "va") || StemmerUtil.endsWith(s2, len, "ve") || StemmerUtil.endsWith(s2, len, "ra") || StemmerUtil.endsWith(s2, len, "re") || StemmerUtil.endsWith(s2, len, "ba") || StemmerUtil.endsWith(s2, len, "be") || StemmerUtil.endsWith(s2, len, "ul") || StemmerUtil.endsWith(s2, len, "ig")) {
                return len - 2;
            }
            if ((StemmerUtil.endsWith(s2, len, "on") || StemmerUtil.endsWith(s2, len, "en")) && !this.isVowel(s2[len - 3])) {
                return len - 2;
            }
            switch (s2[len - 1]) {
                case 'n': 
                case 't': {
                    return len - 1;
                }
                case 'a': 
                case 'e': {
                    if (s2[len - 2] != s2[len - 3] || this.isVowel(s2[len - 2])) break;
                    return len - 2;
                }
            }
        }
        return len;
    }

    private int removePossessive(char[] s2, int len) {
        if (len > 6) {
            if (!this.isVowel(s2[len - 5]) && (StemmerUtil.endsWith(s2, len, "atok") || StemmerUtil.endsWith(s2, len, "otok") || StemmerUtil.endsWith(s2, len, "etek"))) {
                return len - 4;
            }
            if (StemmerUtil.endsWith(s2, len, "itek") || StemmerUtil.endsWith(s2, len, "itok")) {
                return len - 4;
            }
        }
        if (len > 5) {
            if (!this.isVowel(s2[len - 4]) && (StemmerUtil.endsWith(s2, len, "unk") || StemmerUtil.endsWith(s2, len, "tok") || StemmerUtil.endsWith(s2, len, "tek"))) {
                return len - 3;
            }
            if (this.isVowel(s2[len - 4]) && StemmerUtil.endsWith(s2, len, "juk")) {
                return len - 3;
            }
            if (StemmerUtil.endsWith(s2, len, "ink")) {
                return len - 3;
            }
        }
        if (len > 4) {
            if (!this.isVowel(s2[len - 3]) && (StemmerUtil.endsWith(s2, len, "am") || StemmerUtil.endsWith(s2, len, "em") || StemmerUtil.endsWith(s2, len, "om") || StemmerUtil.endsWith(s2, len, "ad") || StemmerUtil.endsWith(s2, len, "ed") || StemmerUtil.endsWith(s2, len, "od") || StemmerUtil.endsWith(s2, len, "uk"))) {
                return len - 2;
            }
            if (this.isVowel(s2[len - 3]) && (StemmerUtil.endsWith(s2, len, "nk") || StemmerUtil.endsWith(s2, len, "ja") || StemmerUtil.endsWith(s2, len, "je"))) {
                return len - 2;
            }
            if (StemmerUtil.endsWith(s2, len, "im") || StemmerUtil.endsWith(s2, len, "id") || StemmerUtil.endsWith(s2, len, "ik")) {
                return len - 2;
            }
        }
        if (len > 3) {
            switch (s2[len - 1]) {
                case 'a': 
                case 'e': {
                    if (this.isVowel(s2[len - 2])) break;
                    return len - 1;
                }
                case 'd': 
                case 'm': {
                    if (!this.isVowel(s2[len - 2])) break;
                    return len - 1;
                }
                case 'i': {
                    return len - 1;
                }
            }
        }
        return len;
    }

    private int removePlural(char[] s2, int len) {
        if (len > 3 && s2[len - 1] == 'k') {
            switch (s2[len - 2]) {
                case 'a': 
                case 'e': 
                case 'o': {
                    if (len <= 4) break;
                    return len - 2;
                }
            }
            return len - 1;
        }
        return len;
    }

    private int normalize(char[] s2, int len) {
        if (len > 3) {
            switch (s2[len - 1]) {
                case 'a': 
                case 'e': 
                case 'i': 
                case 'o': {
                    return len - 1;
                }
            }
        }
        return len;
    }

    private boolean isVowel(char ch) {
        switch (ch) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': 
            case 'y': {
                return true;
            }
        }
        return false;
    }
}

