/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tr;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class TurkishLowerCaseFilter
extends TokenFilter {
    private static final int LATIN_CAPITAL_LETTER_I = 73;
    private static final int LATIN_SMALL_LETTER_I = 105;
    private static final int LATIN_SMALL_LETTER_DOTLESS_I = 305;
    private static final int COMBINING_DOT_ABOVE = 775;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public TurkishLowerCaseFilter(TokenStream in) {
        super(in);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        boolean iOrAfter = false;
        if (this.input.incrementToken()) {
            char[] buffer = this.termAtt.buffer();
            int length = this.termAtt.length();
            int i2 = 0;
            block4: while (i2 < length) {
                int ch = Character.codePointAt(buffer, i2, length);
                boolean bl = iOrAfter = ch == 73 || iOrAfter && Character.getType(ch) == 6;
                if (iOrAfter) {
                    switch (ch) {
                        case 775: {
                            length = this.delete(buffer, i2, length);
                            continue block4;
                        }
                        case 73: {
                            if (this.isBeforeDot(buffer, i2 + 1, length)) {
                                buffer[i2] = 105;
                            } else {
                                buffer[i2] = 305;
                                iOrAfter = false;
                            }
                            ++i2;
                            continue block4;
                        }
                    }
                }
                i2 += Character.toChars(Character.toLowerCase(ch), buffer, i2);
            }
            this.termAtt.setLength(length);
            return true;
        }
        return false;
    }

    private boolean isBeforeDot(char[] s2, int pos, int len) {
        int ch;
        for (int i2 = pos; i2 < len; i2 += Character.charCount(ch)) {
            ch = Character.codePointAt(s2, i2, len);
            if (Character.getType(ch) != 6) {
                return false;
            }
            if (ch != 775) continue;
            return true;
        }
        return false;
    }

    private int delete(char[] s2, int pos, int len) {
        if (pos < len) {
            System.arraycopy(s2, pos + 1, s2, pos, len - pos - 1);
        }
        return len - 1;
    }
}

