/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.RangeFieldQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public class LongRange
extends Field {
    public static final int BYTES = 8;

    public LongRange(String name, long[] min2, long[] max2) {
        super(name, LongRange.getType(min2.length));
        this.setRangeValues(min2, max2);
    }

    private static FieldType getType(int dimensions) {
        if (dimensions > 4) {
            throw new IllegalArgumentException("LongRange does not support greater than 4 dimensions");
        }
        FieldType ft = new FieldType();
        ft.setDimensions(dimensions * 2, 8);
        ft.freeze();
        return ft;
    }

    public void setRangeValues(long[] min2, long[] max2) {
        byte[] bytes;
        LongRange.checkArgs(min2, max2);
        if (min2.length * 2 != this.type.pointDimensionCount() || max2.length * 2 != this.type.pointDimensionCount()) {
            throw new IllegalArgumentException("field (name=" + this.name + ") uses " + this.type.pointDimensionCount() / 2 + " dimensions; cannot change to (incoming) " + min2.length + " dimensions");
        }
        if (this.fieldsData == null) {
            bytes = new byte[16 * min2.length];
            this.fieldsData = new BytesRef(bytes);
        } else {
            bytes = ((BytesRef)this.fieldsData).bytes;
        }
        LongRange.verifyAndEncode(min2, max2, bytes);
    }

    private static void checkArgs(long[] min2, long[] max2) {
        if (min2 == null || max2 == null || min2.length == 0 || max2.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min2.length != max2.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        if (min2.length > 4) {
            throw new IllegalArgumentException("LongRange does not support greater than 4 dimensions");
        }
    }

    private static byte[] encode(long[] min2, long[] max2) {
        LongRange.checkArgs(min2, max2);
        byte[] b = new byte[16 * min2.length];
        LongRange.verifyAndEncode(min2, max2, b);
        return b;
    }

    static void verifyAndEncode(long[] min2, long[] max2, byte[] bytes) {
        int d = 0;
        int i2 = 0;
        int j = min2.length * 8;
        while (d < min2.length) {
            if (Double.isNaN(min2[d])) {
                throw new IllegalArgumentException("invalid min value (NaN) in LongRange");
            }
            if (Double.isNaN(max2[d])) {
                throw new IllegalArgumentException("invalid max value (NaN) in LongRange");
            }
            if (min2[d] > max2[d]) {
                throw new IllegalArgumentException("min value (" + min2[d] + ") is greater than max value (" + max2[d] + ")");
            }
            LongRange.encode(min2[d], bytes, i2);
            LongRange.encode(max2[d], bytes, j);
            ++d;
            i2 += 8;
            j += 8;
        }
    }

    private static void encode(long val, byte[] bytes, int offset) {
        NumericUtils.longToSortableBytes(val, bytes, offset);
    }

    public long getMin(int dimension) {
        if (dimension < 0 || dimension >= this.type.pointDimensionCount() / 2) {
            throw new IllegalArgumentException("dimension request (" + dimension + ") out of bounds for field (name=" + this.name + " dimensions=" + this.type.pointDimensionCount() / 2 + "). ");
        }
        return LongRange.decodeMin(((BytesRef)this.fieldsData).bytes, dimension);
    }

    public long getMax(int dimension) {
        if (dimension < 0 || dimension >= this.type.pointDimensionCount() / 2) {
            throw new IllegalArgumentException("dimension request (" + dimension + ") out of bounds for field (name=" + this.name + " dimensions=" + this.type.pointDimensionCount() / 2 + "). ");
        }
        return LongRange.decodeMax(((BytesRef)this.fieldsData).bytes, dimension);
    }

    static long decodeMin(byte[] b, int dimension) {
        int offset = dimension * 8;
        return NumericUtils.sortableBytesToLong(b, offset);
    }

    static long decodeMax(byte[] b, int dimension) {
        int offset = b.length / 2 + dimension * 8;
        return NumericUtils.sortableBytesToLong(b, offset);
    }

    public static Query newIntersectsQuery(String field, long[] min2, long[] max2) {
        return LongRange.newRelationQuery(field, min2, max2, RangeFieldQuery.QueryType.INTERSECTS);
    }

    public static Query newContainsQuery(String field, long[] min2, long[] max2) {
        return LongRange.newRelationQuery(field, min2, max2, RangeFieldQuery.QueryType.CONTAINS);
    }

    public static Query newWithinQuery(String field, long[] min2, long[] max2) {
        return LongRange.newRelationQuery(field, min2, max2, RangeFieldQuery.QueryType.WITHIN);
    }

    public static Query newCrossesQuery(String field, long[] min2, long[] max2) {
        return LongRange.newRelationQuery(field, min2, max2, RangeFieldQuery.QueryType.CROSSES);
    }

    private static Query newRelationQuery(String field, long[] min2, long[] max2, RangeFieldQuery.QueryType relation) {
        LongRange.checkArgs(min2, max2);
        return new RangeFieldQuery(field, LongRange.encode(min2, max2), min2.length, relation){

            @Override
            protected String toString(byte[] ranges, int dimension) {
                return LongRange.toString(ranges, dimension);
            }
        };
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" <");
        sb.append(this.name);
        sb.append(':');
        byte[] b = ((BytesRef)this.fieldsData).bytes;
        LongRange.toString(b, 0);
        for (int d = 1; d < this.type.pointDimensionCount(); ++d) {
            sb.append(' ');
            LongRange.toString(b, d);
        }
        sb.append('>');
        return sb.toString();
    }

    private static String toString(byte[] ranges, int dimension) {
        return "[" + Long.toString(LongRange.decodeMin(ranges, dimension)) + " : " + Long.toString(LongRange.decodeMax(ranges, dimension)) + "]";
    }
}

