/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.index.MultiPostingsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.PriorityQueue;

public final class MultiTermsEnum
extends TermsEnum {
    private static final Comparator<TermsEnumWithSlice> INDEX_COMPARATOR = new Comparator<TermsEnumWithSlice>(){

        @Override
        public int compare(TermsEnumWithSlice o1, TermsEnumWithSlice o2) {
            return o1.index - o2.index;
        }
    };
    private final TermMergeQueue queue;
    private final TermsEnumWithSlice[] subs;
    private final TermsEnumWithSlice[] currentSubs;
    private final TermsEnumWithSlice[] top;
    private final MultiPostingsEnum.EnumWithSlice[] subDocs;
    private BytesRef lastSeek;
    private boolean lastSeekExact;
    private final BytesRefBuilder lastSeekScratch = new BytesRefBuilder();
    private int numTop;
    private int numSubs;
    private BytesRef current;

    public int getMatchCount() {
        return this.numTop;
    }

    public TermsEnumWithSlice[] getMatchArray() {
        return this.top;
    }

    public MultiTermsEnum(ReaderSlice[] slices) {
        this.queue = new TermMergeQueue(slices.length);
        this.top = new TermsEnumWithSlice[slices.length];
        this.subs = new TermsEnumWithSlice[slices.length];
        this.subDocs = new MultiPostingsEnum.EnumWithSlice[slices.length];
        for (int i2 = 0; i2 < slices.length; ++i2) {
            this.subs[i2] = new TermsEnumWithSlice(i2, slices[i2]);
            this.subDocs[i2] = new MultiPostingsEnum.EnumWithSlice();
            this.subDocs[i2].slice = slices[i2];
        }
        this.currentSubs = new TermsEnumWithSlice[slices.length];
    }

    @Override
    public BytesRef term() {
        return this.current;
    }

    public TermsEnum reset(TermsEnumIndex[] termsEnumsIndex) throws IOException {
        assert (termsEnumsIndex.length <= this.top.length);
        this.numSubs = 0;
        this.numTop = 0;
        this.queue.clear();
        for (int i2 = 0; i2 < termsEnumsIndex.length; ++i2) {
            TermsEnumIndex termsEnumIndex = termsEnumsIndex[i2];
            assert (termsEnumIndex != null);
            BytesRef term = termsEnumIndex.termsEnum.next();
            if (term == null) continue;
            TermsEnumWithSlice entry = this.subs[termsEnumIndex.subIndex];
            entry.reset(termsEnumIndex.termsEnum, term);
            this.queue.add(entry);
            this.currentSubs[this.numSubs++] = entry;
        }
        if (this.queue.size() == 0) {
            return TermsEnum.EMPTY;
        }
        return this;
    }

    @Override
    public boolean seekExact(BytesRef term) throws IOException {
        this.queue.clear();
        this.numTop = 0;
        boolean seekOpt = false;
        if (this.lastSeek != null && this.lastSeek.compareTo(term) <= 0) {
            seekOpt = true;
        }
        this.lastSeek = null;
        this.lastSeekExact = true;
        for (int i2 = 0; i2 < this.numSubs; ++i2) {
            int cmp;
            BytesRef curTerm;
            boolean status = seekOpt ? ((curTerm = this.currentSubs[i2].current) != null ? ((cmp = term.compareTo(curTerm)) == 0 ? true : (cmp < 0 ? false : this.currentSubs[i2].terms.seekExact(term))) : false) : this.currentSubs[i2].terms.seekExact(term);
            if (!status) continue;
            this.top[this.numTop++] = this.currentSubs[i2];
            this.current = this.currentSubs[i2].current = this.currentSubs[i2].terms.term();
            assert (term.equals(this.currentSubs[i2].current));
        }
        return this.numTop > 0;
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef term) throws IOException {
        this.queue.clear();
        this.numTop = 0;
        this.lastSeekExact = false;
        boolean seekOpt = false;
        if (this.lastSeek != null && this.lastSeek.compareTo(term) <= 0) {
            seekOpt = true;
        }
        this.lastSeekScratch.copyBytes(term);
        this.lastSeek = this.lastSeekScratch.get();
        for (int i2 = 0; i2 < this.numSubs; ++i2) {
            int cmp;
            BytesRef curTerm;
            TermsEnum.SeekStatus status = seekOpt ? ((curTerm = this.currentSubs[i2].current) != null ? ((cmp = term.compareTo(curTerm)) == 0 ? TermsEnum.SeekStatus.FOUND : (cmp < 0 ? TermsEnum.SeekStatus.NOT_FOUND : this.currentSubs[i2].terms.seekCeil(term))) : TermsEnum.SeekStatus.END) : this.currentSubs[i2].terms.seekCeil(term);
            if (status == TermsEnum.SeekStatus.FOUND) {
                this.top[this.numTop++] = this.currentSubs[i2];
                this.current = this.currentSubs[i2].current = this.currentSubs[i2].terms.term();
                this.queue.add(this.currentSubs[i2]);
                continue;
            }
            if (status == TermsEnum.SeekStatus.NOT_FOUND) {
                this.currentSubs[i2].current = this.currentSubs[i2].terms.term();
                assert (this.currentSubs[i2].current != null);
                this.queue.add(this.currentSubs[i2]);
                continue;
            }
            assert (status == TermsEnum.SeekStatus.END);
            this.currentSubs[i2].current = null;
        }
        if (this.numTop > 0) {
            return TermsEnum.SeekStatus.FOUND;
        }
        if (this.queue.size() > 0) {
            this.pullTop();
            return TermsEnum.SeekStatus.NOT_FOUND;
        }
        return TermsEnum.SeekStatus.END;
    }

    @Override
    public void seekExact(long ord) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ord() {
        throw new UnsupportedOperationException();
    }

    private void pullTop() {
        assert (this.numTop == 0);
        this.numTop = this.queue.fillTop(this.top);
        this.current = this.top[0].current;
    }

    private void pushTop() throws IOException {
        for (int i2 = 0; i2 < this.numTop; ++i2) {
            TermsEnumWithSlice top = (TermsEnumWithSlice)this.queue.top();
            top.current = top.terms.next();
            if (top.current == null) {
                this.queue.pop();
                continue;
            }
            this.queue.updateTop();
        }
        this.numTop = 0;
    }

    @Override
    public BytesRef next() throws IOException {
        if (this.lastSeekExact) {
            TermsEnum.SeekStatus status = this.seekCeil(this.current);
            assert (status == TermsEnum.SeekStatus.FOUND);
            this.lastSeekExact = false;
        }
        this.lastSeek = null;
        this.pushTop();
        if (this.queue.size() > 0) {
            this.pullTop();
        } else {
            this.current = null;
        }
        return this.current;
    }

    @Override
    public int docFreq() throws IOException {
        int sum = 0;
        for (int i2 = 0; i2 < this.numTop; ++i2) {
            sum += this.top[i2].terms.docFreq();
        }
        return sum;
    }

    @Override
    public long totalTermFreq() throws IOException {
        long sum = 0L;
        for (int i2 = 0; i2 < this.numTop; ++i2) {
            long v = this.top[i2].terms.totalTermFreq();
            if (v == -1L) {
                return v;
            }
            sum += v;
        }
        return sum;
    }

    @Override
    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        MultiPostingsEnum docsEnum;
        if (reuse != null && reuse instanceof MultiPostingsEnum) {
            docsEnum = (MultiPostingsEnum)reuse;
            if (!docsEnum.canReuse(this)) {
                docsEnum = new MultiPostingsEnum(this, this.subs.length);
            }
        } else {
            docsEnum = new MultiPostingsEnum(this, this.subs.length);
        }
        int upto = 0;
        ArrayUtil.timSort(this.top, 0, this.numTop, INDEX_COMPARATOR);
        for (int i2 = 0; i2 < this.numTop; ++i2) {
            TermsEnumWithSlice entry = this.top[i2];
            assert (entry.index < docsEnum.subPostingsEnums.length) : entry.index + " vs " + docsEnum.subPostingsEnums.length + "; " + this.subs.length;
            PostingsEnum subPostingsEnum = entry.terms.postings(docsEnum.subPostingsEnums[entry.index], flags);
            assert (subPostingsEnum != null);
            docsEnum.subPostingsEnums[entry.index] = subPostingsEnum;
            this.subDocs[upto].postingsEnum = subPostingsEnum;
            this.subDocs[upto].slice = entry.subSlice;
            ++upto;
        }
        return docsEnum.reset(this.subDocs, upto);
    }

    public String toString() {
        return "MultiTermsEnum(" + Arrays.toString(this.subs) + ")";
    }

    private static final class TermMergeQueue
    extends PriorityQueue<TermsEnumWithSlice> {
        final int[] stack;

        TermMergeQueue(int size) {
            super(size);
            this.stack = new int[size];
        }

        @Override
        protected boolean lessThan(TermsEnumWithSlice termsA, TermsEnumWithSlice termsB) {
            return termsA.current.compareTo(termsB.current) < 0;
        }

        int fillTop(TermsEnumWithSlice[] tops) {
            int size = this.size();
            if (size == 0) {
                return 0;
            }
            tops[0] = (TermsEnumWithSlice)this.top();
            int numTop = 1;
            this.stack[0] = 1;
            int stackLen = 1;
            while (stackLen != 0) {
                int leftChild;
                int index = this.stack[--stackLen];
                int end = Math.min(size, leftChild + 1);
                for (int child = leftChild = index << 1; child <= end; ++child) {
                    TermsEnumWithSlice te = this.get(child);
                    if (!te.current.equals(tops[0].current)) continue;
                    tops[numTop++] = te;
                    this.stack[stackLen++] = child;
                }
            }
            return numTop;
        }

        private TermsEnumWithSlice get(int i2) {
            return (TermsEnumWithSlice)this.getHeapArray()[i2];
        }
    }

    static final class TermsEnumWithSlice {
        private final ReaderSlice subSlice;
        TermsEnum terms;
        public BytesRef current;
        final int index;

        public TermsEnumWithSlice(int index, ReaderSlice subSlice) {
            this.subSlice = subSlice;
            this.index = index;
            assert (subSlice.length >= 0) : "length=" + subSlice.length;
        }

        public void reset(TermsEnum terms, BytesRef term) {
            this.terms = terms;
            this.current = term;
        }

        public String toString() {
            return this.subSlice.toString() + ":" + this.terms;
        }
    }

    static class TermsEnumIndex {
        public static final TermsEnumIndex[] EMPTY_ARRAY = new TermsEnumIndex[0];
        final int subIndex;
        final TermsEnum termsEnum;

        public TermsEnumIndex(TermsEnum termsEnum, int subIndex) {
            this.termsEnum = termsEnum;
            this.subIndex = subIndex;
        }
    }
}

