/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PagedGrowableWriter;
import org.apache.lucene.util.packed.PagedMutable;

class NumericDocValuesFieldUpdates
extends DocValuesFieldUpdates {
    private final int bitsPerValue;
    private PagedMutable docs;
    private PagedGrowableWriter values;
    private int size;

    public NumericDocValuesFieldUpdates(long delGen, String field, int maxDoc) {
        super(maxDoc, delGen, field, DocValuesType.NUMERIC);
        this.bitsPerValue = PackedInts.bitsRequired(maxDoc - 1);
        this.docs = new PagedMutable(1L, 1024, this.bitsPerValue, 0.0f);
        this.values = new PagedGrowableWriter(1L, 1024, 1, 0.5f);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public synchronized void add(int doc, Object value) {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        assert (doc < this.maxDoc);
        if (this.size == Integer.MAX_VALUE) {
            throw new IllegalStateException("cannot support more than Integer.MAX_VALUE doc/value entries");
        }
        Long val = (Long)value;
        if (this.docs.size() == (long)this.size) {
            this.docs = (PagedMutable)this.docs.grow(this.size + 1);
            this.values = (PagedGrowableWriter)this.values.grow(this.size + 1);
        }
        this.docs.set(this.size, doc);
        this.values.set(this.size, val);
        ++this.size;
    }

    @Override
    public void finish() {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        if ((long)this.size < this.docs.size()) {
            this.docs = (PagedMutable)this.docs.resize(this.size);
            this.values = (PagedGrowableWriter)this.values.resize(this.size);
        }
        new InPlaceMergeSorter(){

            @Override
            protected void swap(int i2, int j) {
                long tmpDoc = NumericDocValuesFieldUpdates.this.docs.get(j);
                NumericDocValuesFieldUpdates.this.docs.set(j, NumericDocValuesFieldUpdates.this.docs.get(i2));
                NumericDocValuesFieldUpdates.this.docs.set(i2, tmpDoc);
                long tmpVal = NumericDocValuesFieldUpdates.this.values.get(j);
                NumericDocValuesFieldUpdates.this.values.set(j, NumericDocValuesFieldUpdates.this.values.get(i2));
                NumericDocValuesFieldUpdates.this.values.set(i2, tmpVal);
            }

            @Override
            protected int compare(int i2, int j) {
                return Integer.compare((int)NumericDocValuesFieldUpdates.this.docs.get(i2), (int)NumericDocValuesFieldUpdates.this.docs.get(j));
            }
        }.sort(0, this.size);
    }

    @Override
    public Iterator iterator() {
        if (!this.finished) {
            throw new IllegalStateException("call finish first");
        }
        return new Iterator(this.size, this.values, this.docs, this.delGen);
    }

    @Override
    public boolean any() {
        return this.size > 0;
    }

    @Override
    public long ramBytesUsed() {
        return this.values.ramBytesUsed() + this.docs.ramBytesUsed() + (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8L + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
    }

    static final class Iterator
    extends DocValuesFieldUpdates.Iterator {
        private final int size;
        private final PagedGrowableWriter values;
        private final PagedMutable docs;
        private long idx = 0L;
        private int doc = -1;
        private Long value = null;
        private final long delGen;

        Iterator(int size, PagedGrowableWriter values, PagedMutable docs, long delGen) {
            this.size = size;
            this.values = values;
            this.docs = docs;
            this.delGen = delGen;
        }

        @Override
        Long value() {
            return this.value;
        }

        @Override
        int nextDoc() {
            if (this.idx >= (long)this.size) {
                this.value = null;
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = (int)this.docs.get(this.idx);
            ++this.idx;
            while (this.idx < (long)this.size && this.docs.get(this.idx) == (long)this.doc) {
                ++this.idx;
            }
            this.value = this.values.get(this.idx - 1L);
            return this.doc;
        }

        @Override
        int doc() {
            return this.doc;
        }

        @Override
        long delGen() {
            return this.delGen;
        }
    }
}

