/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Comparator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntroSorter;

final class ArrayIntroSorter<T>
extends IntroSorter {
    private final T[] arr;
    private final Comparator<? super T> comparator;
    private T pivot;

    public ArrayIntroSorter(T[] arr, Comparator<? super T> comparator) {
        this.arr = arr;
        this.comparator = comparator;
        this.pivot = null;
    }

    @Override
    protected int compare(int i2, int j) {
        return this.comparator.compare(this.arr[i2], this.arr[j]);
    }

    @Override
    protected void swap(int i2, int j) {
        ArrayUtil.swap(this.arr, i2, j);
    }

    @Override
    protected void setPivot(int i2) {
        this.pivot = this.arr[i2];
    }

    @Override
    protected int comparePivot(int i2) {
        return this.comparator.compare(this.pivot, this.arr[i2]);
    }
}

