/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.packed.AbstractBlockPackedWriter;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

public final class MonotonicBlockPackedWriter
extends AbstractBlockPackedWriter {
    public MonotonicBlockPackedWriter(DataOutput out, int blockSize) {
        super(out, blockSize);
    }

    @Override
    public void add(long l) throws IOException {
        assert (l >= 0L);
        super.add(l);
    }

    @Override
    protected void flush() throws IOException {
        assert (this.off > 0);
        float avg = this.off == 1 ? 0.0f : (float)(this.values[this.off - 1] - this.values[0]) / (float)(this.off - 1);
        long min2 = this.values[0];
        for (int i2 = 1; i2 < this.off; ++i2) {
            long actual = this.values[i2];
            long expected = MonotonicBlockPackedReader.expected(min2, avg, i2);
            if (expected <= actual) continue;
            min2 -= expected - actual;
        }
        long maxDelta = 0L;
        for (int i3 = 0; i3 < this.off; ++i3) {
            this.values[i3] = this.values[i3] - MonotonicBlockPackedReader.expected(min2, avg, i3);
            maxDelta = Math.max(maxDelta, this.values[i3]);
        }
        this.out.writeZLong(min2);
        this.out.writeInt(Float.floatToIntBits(avg));
        if (maxDelta == 0L) {
            this.out.writeVInt(0);
        } else {
            int bitsRequired = PackedInts.bitsRequired(maxDelta);
            this.out.writeVInt(bitsRequired);
            this.writeValues(bitsRequired);
        }
        this.off = 0;
    }
}

