/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.handlers.ocfl;

import edu.wisc.library.ocfl.api.MutableOcflRepository;
import edu.wisc.library.ocfl.api.OcflObjectUpdater;
import edu.wisc.library.ocfl.api.OcflOption;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.VersionInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.fcrepo.storage.ocfl.CommitType;
import org.fcrepo.storage.ocfl.InteractionModel;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.fcrepo.storage.ocfl.OcflVersionInfo;
import org.fcrepo.storage.ocfl.PersistencePaths;
import org.fcrepo.storage.ocfl.ResourceContent;
import org.fcrepo.storage.ocfl.ResourceHeaders;

public class PlainOcflObjectSession
implements OcflObjectSession {
    private final MutableOcflRepository ocflRepo;
    private final String sessionId;
    private final String ocflObjectId;
    private final VersionInfo versionInfo;
    private final Path objectStaging;
    private final OcflOption[] ocflOptions;
    private final Set<String> deletePaths;
    private boolean closed = false;

    public PlainOcflObjectSession(String sessionId, MutableOcflRepository ocflRepo, String ocflObjectId, Path objectStaging) {
        this.sessionId = sessionId;
        this.ocflRepo = ocflRepo;
        this.ocflObjectId = ocflObjectId;
        this.objectStaging = objectStaging;
        this.versionInfo = new VersionInfo();
        this.ocflOptions = new OcflOption[]{OcflOption.MOVE_SOURCE, OcflOption.OVERWRITE};
        this.deletePaths = new HashSet<String>();
    }

    @Override
    public String sessionId() {
        return this.sessionId;
    }

    @Override
    public String ocflObjectId() {
        return this.ocflObjectId;
    }

    @Override
    public synchronized ResourceHeaders writeResource(ResourceHeaders headers, InputStream content) {
        this.enforceOpen();
        PersistencePaths paths = this.resolvePersistencePaths(headers);
        String contentPath = this.encode(paths.getContentFilePath());
        Path contentDst = this.createStagingPath(contentPath);
        this.write(content, contentDst);
        return headers;
    }

    @Override
    public synchronized void writeHeaders(ResourceHeaders headers) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void versionCreationTimestamp(OffsetDateTime timestamp) {
        this.versionInfo.setCreated(timestamp);
    }

    @Override
    public void versionAuthor(String name, String address) {
        this.versionInfo.setUser(name, address);
    }

    @Override
    public void versionMessage(String message) {
        this.versionInfo.setMessage(message);
    }

    @Override
    public synchronized void commit() {
        this.enforceOpen();
        this.closed = true;
        if (Files.exists(this.objectStaging, new LinkOption[0])) {
            this.ocflRepo.updateObject(ObjectVersionId.head(this.ocflObjectId), this.versionInfo, updater -> {
                if (Files.exists(this.objectStaging, new LinkOption[0])) {
                    if (SystemUtils.IS_OS_WINDOWS) {
                        this.addDecodedPaths((OcflObjectUpdater)updater, this.ocflOptions);
                    } else {
                        updater.addPath(this.objectStaging, this.ocflOptions);
                    }
                }
            });
        }
        if (!this.deletePaths.isEmpty()) {
            this.ocflRepo.updateObject(ObjectVersionId.head(this.ocflObjectId), this.versionInfo, updater -> this.deletePaths.forEach(updater::removeFile));
        }
        this.cleanup();
    }

    @Override
    public void abort() {
        if (!this.closed) {
            this.closed = true;
            this.cleanup();
        }
    }

    @Override
    public void close() {
        this.abort();
    }

    @Override
    public void rollback() {
        throw new UnsupportedOperationException("Rollback is not supported");
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void deleteContentFile(ResourceHeaders headers) {
        this.enforceOpen();
        PersistencePaths paths = this.resolvePersistencePaths(headers);
        this.deletePaths.add(paths.getContentFilePath());
    }

    @Override
    public void deleteResource(String resourceId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResourceHeaders readHeaders(String resourceId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResourceHeaders readHeaders(String resourceId, String versionNumber) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResourceContent readContent(String resourceId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ResourceContent readContent(String resourceId, String versionNumber) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public List<OcflVersionInfo> listVersions(String resourceId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Stream<ResourceHeaders> streamResourceHeaders() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void commitType(CommitType commitType) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean containsResource(String resourceId) {
        return this.ocflRepo.containsObject(this.ocflObjectId);
    }

    private Path stagingPath(String path) {
        return this.objectStaging.resolve(path);
    }

    private Path createStagingPath(String path) {
        Path stagingPath = this.stagingPath(path);
        try {
            Files.createDirectories(stagingPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
        return stagingPath;
    }

    private void write(InputStream content, Path destination) {
        if (content != null) {
            try {
                Files.copy(content, destination, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
    }

    private PersistencePaths resolvePersistencePaths(ResourceHeaders headers) {
        PersistencePaths paths;
        String resourceId = headers.getId();
        if (InteractionModel.ACL.getUri().equals(headers.getInteractionModel())) {
            throw new UnsupportedOperationException("ACLs are not supported");
        }
        if (InteractionModel.NON_RDF.getUri().equals(headers.getInteractionModel())) {
            paths = PersistencePaths.nonRdfResource(this.ocflObjectId, resourceId);
        } else if (headers.getInteractionModel() != null) {
            paths = PersistencePaths.rdfResource(this.ocflObjectId, resourceId);
        } else {
            throw new IllegalArgumentException(String.format("Interaction model for resource %s must be populated.", resourceId));
        }
        return paths;
    }

    private String encode(String value) {
        if (SystemUtils.IS_OS_WINDOWS) {
            String encoded = value.contains("/") ? Arrays.stream(value.split("/")).map(s2 -> URLEncoder.encode(s2, StandardCharsets.UTF_8)).collect(Collectors.joining("/")) : URLEncoder.encode(value, StandardCharsets.UTF_8);
            return encoded;
        }
        return value;
    }

    private void addDecodedPaths(OcflObjectUpdater updater, OcflOption ... ocflOptions) {
        try (Stream<Path> paths = Files.walk(this.objectStaging, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                String logicalPath = this.windowsStagingPathToLogicalPath((Path)file);
                updater.addPath((Path)file, logicalPath, ocflOptions);
            });
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private String windowsStagingPathToLogicalPath(Path path) {
        String normalized = this.objectStaging.relativize(path).toString().replace("\\", "/");
        return URLDecoder.decode(normalized, StandardCharsets.UTF_8);
    }

    private void cleanup() {
        if (Files.exists(this.objectStaging, new LinkOption[0])) {
            FileUtils.deleteQuietly(this.objectStaging.toFile());
        }
    }

    private void enforceOpen() {
        if (this.closed) {
            throw new IllegalStateException(String.format("Session %s is already closed!", this.sessionId));
        }
    }
}

