/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.storage.ocfl.validation;

import java.util.Objects;
import java.util.Set;
import org.fcrepo.storage.ocfl.InteractionModel;
import org.fcrepo.storage.ocfl.PersistencePaths;
import org.fcrepo.storage.ocfl.ResourceHeaders;
import org.fcrepo.storage.ocfl.validation.Context;
import org.fcrepo.storage.ocfl.validation.HeadersValidator;
import org.fcrepo.storage.ocfl.validation.ValidationUtil;

public class DefaultHeadersValidator
implements HeadersValidator {
    private static final Set<String> VALID_EXT_HANDLING = Set.of("proxy", "redirect");

    @Override
    public void validate(PersistencePaths paths, ResourceHeaders headers, ResourceHeaders rootHeaders) {
        Objects.requireNonNull(headers, "headers may not be null");
        Objects.requireNonNull(rootHeaders, "rootHeaders may not be null");
        Context context = new Context();
        this.generalHeaderValidation(context, paths, headers, rootHeaders);
        this.nonRdfHeaderValidation(context, headers);
        if (!Objects.equals(headers.getId(), rootHeaders.getId())) {
            ValidationUtil.requireValue(context, "objectRoot", false, headers.isObjectRoot());
            ValidationUtil.requireValue(context, "archivalGroup", false, headers.isArchivalGroup());
            if (rootHeaders.isArchivalGroup()) {
                this.validateArchivalPartHeaders(context, headers, rootHeaders);
            } else {
                this.validateAtomicPartHeaders(context, headers);
            }
        } else {
            this.validateRootHeaders(context, headers);
        }
        context.throwValidationException();
    }

    private void validateRootHeaders(Context context, ResourceHeaders headers) {
        String model = headers.getInteractionModel();
        if (ValidationUtil.isModel(InteractionModel.ACL, model) || ValidationUtil.isModel(InteractionModel.NON_RDF_DESCRIPTION, model)) {
            context.problem("Invalid interaction model value: %s.", model);
        }
        ValidationUtil.requireValue(context, "objectRoot", true, headers.isObjectRoot());
        ValidationUtil.requireValue(context, "archivalGroupId", null, headers.getArchivalGroupId());
        if (headers.isArchivalGroup() && !ValidationUtil.isContainer(model)) {
            context.problem("Archival Group has an invalid interaction model: %s", model);
        }
    }

    private void generalHeaderValidation(Context context, PersistencePaths paths, ResourceHeaders headers, ResourceHeaders rootHeaders) {
        ValidationUtil.requireValue(context, "headersVersion", "1.0", headers.getHeadersVersion());
        ValidationUtil.validateId(context, "id", headers.getId());
        ValidationUtil.validateId(context, "parent", headers.getParent());
        ValidationUtil.validateIdRelationship(context, "parent", headers.getParent(), "id", headers.getId());
        ValidationUtil.validateIdRelationship(context, "rootId", rootHeaders.getId(), "id", headers.getId());
        ValidationUtil.requireNotNull(context, "stateToken", headers.getStateToken());
        ValidationUtil.validateInteractionModel(context, headers.getInteractionModel());
        ValidationUtil.requireNotNull(context, "createdDate", headers.getCreatedDate());
        ValidationUtil.requireNotNull(context, "lastModifiedDate", headers.getLastModifiedDate());
        boolean contentExpected = ValidationUtil.contentExpected(headers);
        if (paths != null && contentExpected) {
            ValidationUtil.requireValue(context, "contentPath", paths.getContentFilePath(), headers.getContentPath());
        }
        if (rootHeaders.isDeleted()) {
            ValidationUtil.requireValue(context, "deleted", rootHeaders.isDeleted(), headers.isDeleted());
        }
        if (contentExpected) {
            ValidationUtil.requireNotEmpty(context, "digests", headers.getDigests());
        }
        ValidationUtil.validateDigests(context, headers.getDigests());
    }

    private void nonRdfHeaderValidation(Context context, ResourceHeaders headers) {
        if (!headers.isDeleted() && ValidationUtil.isModel(InteractionModel.NON_RDF, headers.getInteractionModel())) {
            ValidationUtil.requireNotNull(context, "mimeType", headers.getMimeType());
        }
        if (headers.getExternalHandling() != null || headers.getExternalUrl() != null) {
            ValidationUtil.requireNotNull(context, "externalUrl", headers.getExternalUrl());
            if (headers.getExternalHandling() == null || !VALID_EXT_HANDLING.contains(headers.getExternalHandling())) {
                context.problem("Must define property 'externalHandling' as one of %s", VALID_EXT_HANDLING);
            }
            ValidationUtil.requireValue(context, "interactionModel", InteractionModel.NON_RDF.getUri(), headers.getInteractionModel());
        }
    }

    private void validateArchivalPartHeaders(Context context, ResourceHeaders headers, ResourceHeaders rootHeaders) {
        ValidationUtil.requireValue(context, "archivalGroupId", rootHeaders.getId(), headers.getArchivalGroupId());
    }

    private void validateAtomicPartHeaders(Context context, ResourceHeaders headers) {
        String model = headers.getInteractionModel();
        if (!ValidationUtil.isModel(InteractionModel.ACL, model) && !ValidationUtil.isModel(InteractionModel.NON_RDF_DESCRIPTION, model)) {
            context.problem("Invalid interaction model %s. Atomic resources may only contain ACLs and non-RDF descriptions.", model);
        } else if (headers.getParent() != null) {
            if (ValidationUtil.isModel(InteractionModel.ACL, model)) {
                ValidationUtil.requireValue(context, "id", headers.getParent() + "/fcr:acl", headers.getId());
            } else {
                ValidationUtil.requireValue(context, "id", headers.getParent() + "/fcr:metadata", headers.getId());
            }
        }
        ValidationUtil.requireValue(context, "archivalGroupId", null, headers.getArchivalGroupId());
    }
}

