/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.storage.ocfl.validation;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.fcrepo.storage.ocfl.InteractionModel;
import org.fcrepo.storage.ocfl.ResourceHeaders;
import org.fcrepo.storage.ocfl.validation.Context;

final class ValidationUtil {
    private static final String INFO_FEDORA = "info:fedora";
    private static final String INFO_FEDORA_PREFIX = "info:fedora/";
    private static final String FCR_PREFIX = "fcr:";
    private static final Set<String> ALLOWED_FCR_PARTS = Set.of("fcr:metadata", "fcr:acl");
    private static final Set<String> FORBIDDEN_PARTS = Set.of("fcr-root", ".fcrepo", "fcr-container.nt", "fcr:tombstone", "fcr:versions");
    private static final Set<String> FORBIDDEN_SUFFIXES = Set.of("~fcr-desc", "~fcr-acl", "~fcr-desc.nt", "~fcr-acl.nt");
    private static final Set<String> VALID_ALGORITHMS = Set.of("sha-1", "sha1", "sha-256", "sha256", "sha-512", "sha512", "sha-512/256", "sha512/256", "md5");

    private ValidationUtil() {
    }

    public static void validateInteractionModel(Context context, String model) {
        ValidationUtil.requireNotNull(context, "interactionModel", model);
        if (model != null) {
            try {
                InteractionModel.fromString(model);
            }
            catch (RuntimeException e2) {
                context.problem("Invalid interaction model value: %s.", model);
            }
        }
    }

    public static void validateId(Context context, String name, String value) {
        ValidationUtil.requireNotNull(context, name, value);
        if (value != null) {
            if (!INFO_FEDORA.equals(value) && !value.startsWith(INFO_FEDORA_PREFIX)) {
                context.problem("Invalid '%s' value '%s'. IDs must be prefixed with '%s'", name, value, INFO_FEDORA_PREFIX);
            }
            String[] parts = value.split("/");
            Iterator<String> it = Arrays.asList(parts).iterator();
            block0: while (it.hasNext()) {
                String part = it.next();
                if (StringUtils.isBlank(part)) {
                    context.problem("Invalid '%s' value '%s'. IDs may not contain blank parts", name, value);
                    break;
                }
                if (FORBIDDEN_PARTS.contains(part)) {
                    context.problem("Invalid '%s' value '%s'. IDs may not contain parts equal to '%s'", name, value, part);
                    break;
                }
                if (part.startsWith(FCR_PREFIX) && !ALLOWED_FCR_PARTS.contains(part)) {
                    context.problem("Invalid '%s' value '%s'. IDs may not contain parts prefixed with 'fcr:'", name, value, part);
                    break;
                }
                if (ALLOWED_FCR_PARTS.contains(part) && it.hasNext()) {
                    context.problem("Invalid '%s' value '%s'. IDs may not have a part following '%s'", name, value, part);
                    break;
                }
                for (String suffix : FORBIDDEN_SUFFIXES) {
                    if (!part.endsWith(suffix) || part.equals(suffix)) continue;
                    context.problem("Invalid '%s' value '%s'. IDs may not contain parts that end with '%s'", name, value, suffix);
                    continue block0;
                }
            }
        }
    }

    public static void validateIdRelationship(Context context, String parentName, String parentValue, String childName, String childValue) {
        if (parentValue != null && childValue != null) {
            Object parentWithSlash;
            Object object = parentWithSlash = parentValue.endsWith("/") ? parentValue : parentValue + "/";
            if (!childValue.equals(parentValue) && !childValue.startsWith((String)parentWithSlash)) {
                context.problem("IDs must be related: %s=%s; %s=%s.", parentName, parentValue, childName, childValue);
            }
        }
    }

    public static void validateDigests(Context context, Collection<URI> digests) {
        if (digests != null && !digests.isEmpty()) {
            for (URI digest : digests) {
                String[] parts = digest.toString().split(":");
                if (parts.length != 3) {
                    context.problem("Digests must be formatted as 'urn:ALGORITHM:DIGEST'. Found: %s.", digest);
                    continue;
                }
                if (!"urn".equals(parts[0])) {
                    context.problem("Digests must begin with 'urn'. Found: %s.", digest);
                }
                if (!VALID_ALGORITHMS.contains(parts[1].toLowerCase())) {
                    context.problem("Digest '%s' contains an invalid algorithm '%s'.", digest, parts[1]);
                }
                if (!StringUtils.isBlank(parts[2])) continue;
                context.problem("Digest '%s' is missing an expected digest value.", digest);
            }
        }
    }

    public static void requireNotNull(Context context, String name, Object value) {
        if (value == null) {
            context.problem("Must define property '%s'", name);
        }
    }

    public static <T> void requireValue(Context context, String name, T expected, T actual) {
        if (!Objects.equals(expected, actual)) {
            context.problem("Must define property '%s' as '%s' but was '%s'", name, expected, actual);
        }
    }

    public static void requireNotEmpty(Context context, String name, Collection<?> collection) {
        ValidationUtil.requireNotNull(context, name, collection);
        if (collection != null && collection.isEmpty()) {
            context.problem("Must contain a '%s' property with at least one entry.", name);
        }
    }

    public static boolean isModel(InteractionModel expected, String actual) {
        return expected.getUri().equals(actual);
    }

    public static boolean contentExpected(ResourceHeaders headers) {
        return !headers.isDeleted() && headers.getExternalHandling() == null;
    }

    public static boolean isContainer(String model) {
        return ValidationUtil.isModel(InteractionModel.BASIC_CONTAINER, model) || ValidationUtil.isModel(InteractionModel.DIRECT_CONTAINER, model) || ValidationUtil.isModel(InteractionModel.INDIRECT_CONTAINER, model);
    }
}

