/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.conversions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.jupiter.params.shadow.com.univocity.parsers.annotations.helpers.AnnotationHelper;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ArgumentUtils;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.DataValidationException;
import org.junit.jupiter.params.shadow.com.univocity.parsers.conversions.Conversion;
import org.junit.jupiter.params.shadow.com.univocity.parsers.conversions.Validator;

public class ValidatedConversion
implements Conversion<Object, Object> {
    private final String regexToMatch;
    private final boolean nullable;
    private final boolean allowBlanks;
    private final Set<String> oneOf;
    private final Set<String> noneOf;
    private final Matcher matcher;
    private final Validator[] validators;

    public ValidatedConversion() {
        this(false, false, null, null, null);
    }

    public ValidatedConversion(String regexToMatch) {
        this(false, false, null, null, regexToMatch);
    }

    public ValidatedConversion(boolean nullable, boolean allowBlanks) {
        this(nullable, allowBlanks, null, null, null);
    }

    public ValidatedConversion(boolean nullable, boolean allowBlanks, String[] oneOf, String[] noneOf, String regexToMatch) {
        this(nullable, allowBlanks, oneOf, noneOf, regexToMatch, null);
    }

    public ValidatedConversion(boolean nullable, boolean allowBlanks, String[] oneOf, String[] noneOf, String regexToMatch, Class[] validators) {
        this.regexToMatch = regexToMatch;
        this.matcher = regexToMatch == null || regexToMatch.isEmpty() ? null : Pattern.compile(regexToMatch).matcher("");
        this.nullable = nullable;
        this.allowBlanks = allowBlanks;
        this.oneOf = oneOf == null || oneOf.length == 0 ? null : new HashSet<String>(Arrays.asList(oneOf));
        this.noneOf = noneOf == null || noneOf.length == 0 ? null : new HashSet<String>(Arrays.asList(noneOf));
        this.validators = validators == null || validators.length == 0 ? new Validator[]{} : this.instantiateValidators(validators);
    }

    private Validator[] instantiateValidators(Class[] validators) {
        Validator[] out = new Validator[validators.length];
        for (int i2 = 0; i2 < validators.length; ++i2) {
            out[i2] = (Validator)AnnotationHelper.newInstance(Validator.class, validators[i2], ArgumentUtils.EMPTY_STRING_ARRAY);
        }
        return out;
    }

    @Override
    public Object execute(Object input) {
        this.validate(input);
        return input;
    }

    @Override
    public Object revert(Object input) {
        this.validate(input);
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validate(Object value) {
        DataValidationException e2 = null;
        String str2 = null;
        if (value == null) {
            if (this.nullable) {
                if (this.noneOf == null || !this.noneOf.contains(null)) return;
                e2 = new DataValidationException("Value '{value}' is not allowed.");
            } else {
                if (this.oneOf != null && this.oneOf.contains(null)) {
                    return;
                }
                e2 = new DataValidationException("Null values not allowed.");
            }
        } else {
            str2 = String.valueOf(value);
            if (str2.trim().isEmpty()) {
                if (this.allowBlanks) {
                    if (this.noneOf == null || !this.noneOf.contains(str2)) return;
                    e2 = new DataValidationException("Value '{value}' is not allowed.");
                } else {
                    if (this.oneOf != null && this.oneOf.contains(str2)) {
                        return;
                    }
                    e2 = new DataValidationException("Blanks are not allowed. '{value}' is blank.");
                }
            }
            if (this.matcher != null && e2 == null) {
                boolean match;
                Matcher matcher = this.matcher;
                synchronized (matcher) {
                    match = this.matcher.reset(str2).matches();
                }
                if (!match) {
                    e2 = new DataValidationException("Value '{value}' does not match expected pattern: '" + this.regexToMatch + "'");
                }
            }
        }
        if (this.oneOf != null && !this.oneOf.contains(str2)) {
            e2 = new DataValidationException("Value '{value}' is not allowed. Expecting one of: " + this.oneOf);
        }
        if (e2 == null && this.noneOf != null && this.noneOf.contains(str2)) {
            e2 = new DataValidationException("Value '{value}' is not allowed.");
        }
        for (int i2 = 0; e2 == null && i2 < this.validators.length; ++i2) {
            String error = this.validators[i2].validate(value);
            if (error == null || error.trim().isEmpty()) continue;
            e2 = new DataValidationException("Value '{value}' didn't pass validation: " + error);
        }
        if (e2 == null) return;
        e2.setValue(value);
        throw e2;
    }
}

