/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.api;

import edu.wisc.library.ocfl.api.OcflConstants;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.OcflVersion;
import edu.wisc.library.ocfl.api.util.Enforce;
import java.util.regex.Pattern;

public class OcflConfig {
    private OcflVersion ocflVersion;
    private DigestAlgorithm defaultDigestAlgorithm;
    private String defaultContentDirectory;

    public OcflConfig() {
        this.ocflVersion = OcflConstants.DEFAULT_OCFL_VERSION;
        this.defaultDigestAlgorithm = OcflConstants.DEFAULT_DIGEST_ALGORITHM;
        this.defaultContentDirectory = "content";
    }

    public OcflConfig(OcflConfig original) {
        this.ocflVersion = original.ocflVersion;
        this.defaultDigestAlgorithm = original.defaultDigestAlgorithm;
        this.defaultContentDirectory = original.defaultContentDirectory;
    }

    public OcflConfig setOcflVersion(OcflVersion ocflVersion) {
        this.ocflVersion = Enforce.notNull(ocflVersion, "ocflVersion cannot be null");
        return this;
    }

    public OcflVersion getOcflVersion() {
        return this.ocflVersion;
    }

    public OcflConfig setDefaultDigestAlgorithm(DigestAlgorithm defaultDigestAlgorithm) {
        Enforce.notNull(defaultDigestAlgorithm, "defaultDigestAlgorithm cannot be null");
        this.defaultDigestAlgorithm = Enforce.expressionTrue(OcflConstants.ALLOWED_DIGEST_ALGORITHMS.contains(defaultDigestAlgorithm), defaultDigestAlgorithm, "Digest algorithm must be one of: " + OcflConstants.ALLOWED_DIGEST_ALGORITHMS);
        return this;
    }

    public DigestAlgorithm getDefaultDigestAlgorithm() {
        return this.defaultDigestAlgorithm;
    }

    public OcflConfig setDefaultContentDirectory(String defaultContentDirectory) {
        Enforce.notBlank(defaultContentDirectory, "contentDirectory cannot be blank");
        this.defaultContentDirectory = Enforce.expressionTrue(!Pattern.matches(".*[/\\\\].*", defaultContentDirectory), defaultContentDirectory, "Content directory cannot contain / or \\");
        return this;
    }

    public String getDefaultContentDirectory() {
        return this.defaultContentDirectory;
    }
}

