/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage.filesystem;

import edu.wisc.library.ocfl.api.OcflFileRetriever;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.io.FixityCheckInputStream;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.util.Enforce;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class FileSystemOcflFileRetriever
implements OcflFileRetriever {
    private final Path filePath;
    private final DigestAlgorithm digestAlgorithm;
    private final String digestValue;

    public FileSystemOcflFileRetriever(Path filePath, DigestAlgorithm digestAlgorithm, String digestValue) {
        this.filePath = Enforce.notNull(filePath, "filePath cannot be null");
        this.digestAlgorithm = Enforce.notNull(digestAlgorithm, "digestAlgorithm cannot be null");
        this.digestValue = Enforce.notBlank(digestValue, "digestValue cannot be null");
    }

    @Override
    public FixityCheckInputStream retrieveFile() {
        try {
            return new FixityCheckInputStream(Files.newInputStream(this.filePath, new OpenOption[0]), this.digestAlgorithm, this.digestValue);
        }
        catch (IOException e2) {
            throw new OcflIOException(e2);
        }
    }
}

