/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.validation;

import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.api.util.Enforce;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

class ContentPaths {
    private final Map<VersionNum, Set<String>> contentPaths;

    public ContentPaths(Collection<String> contentPaths) {
        Enforce.notNull(contentPaths, "contentPaths cannto be null");
        this.contentPaths = new HashMap<VersionNum, Set<String>>();
        contentPaths.forEach(path -> {
            int end = path.indexOf(47);
            VersionNum version2 = VersionNum.fromString(path.substring(0, end));
            this.contentPaths.computeIfAbsent(version2, k -> new HashSet()).add(path);
        });
    }

    public Iterator<String> pathsForVersion(final VersionNum versionNum) {
        return new Iterator<String>(){
            VersionNum currentVersion;
            Iterator<String> currentPaths;
            {
                this.currentVersion = versionNum;
                this.currentPaths = ContentPaths.this.contentPaths.getOrDefault(this.currentVersion, Collections.emptySet()).iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.currentPaths.hasNext()) {
                    return true;
                }
                if (this.currentVersion.getVersionNum() > 1L) {
                    this.currentVersion = this.currentVersion.previousVersionNum();
                    this.currentPaths = ContentPaths.this.contentPaths.getOrDefault(this.currentVersion, Collections.emptySet()).iterator();
                    return this.hasNext();
                }
                return false;
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    return this.currentPaths.next();
                }
                throw new NoSuchElementException("No more content paths");
            }
        };
    }
}

