/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.lang.JsonLDReader;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.lang.ReaderRDFNULL;
import org.apache.jena.riot.lang.ReaderRIOTRDFXML;
import org.apache.jena.riot.lang.ReaderTriX;
import org.apache.jena.riot.lang.RiotParsers;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.thrift.BinRDF;
import org.apache.jena.riot.thrift.RiotThriftException;
import org.apache.jena.sparql.util.Context;

public class RDFParserRegistry {
    private static Map<String, Lang> mapJenaNameToLang = new HashMap<String, Lang>();
    private static Map<Lang, ReaderRIOTFactory> langToParserFactory = new HashMap<Lang, ReaderRIOTFactory>();
    private static Set<Lang> langTriples = new HashSet<Lang>();
    private static Set<Lang> langQuads = new HashSet<Lang>();
    private static ReaderRIOTFactory parserFactory = new ReaderRIOTLangFactory();
    private static ReaderRIOTFactory parserFactoryRDFXML = new ReaderRIOTRDFXML.Factory();
    private static ReaderRIOTFactory parserFactoryJsonLD = new ReaderRIOTFactoryJSONLD();
    private static ReaderRIOTFactory parserFactoryThrift = new ReaderRIOTFactoryThrift();
    private static ReaderRIOTFactory parserFactoryTriX = new ReaderTriX.ReaderRIOTFactoryTriX();
    private static ReaderRIOTFactory parserFactoryRDFNULL = new ReaderRDFNULL.Factory();
    private static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        RDFParserRegistry.initStandard();
    }

    private static void initStandard() {
        RDFLanguages.init();
        RDFParserRegistry.registerLangTriples(Lang.NTRIPLES, parserFactory);
        RDFParserRegistry.registerLangTriples(Lang.N3, parserFactory);
        RDFParserRegistry.registerLangTriples(Lang.TURTLE, parserFactory);
        RDFParserRegistry.registerLangTriples(Lang.RDFJSON, parserFactory);
        RDFParserRegistry.registerLangTriples(Lang.RDFXML, parserFactoryRDFXML);
        RDFParserRegistry.registerLangTriples(Lang.JSONLD, parserFactoryJsonLD);
        RDFParserRegistry.registerLangTriples(Lang.RDFTHRIFT, parserFactoryThrift);
        RDFParserRegistry.registerLangTriples(Lang.TRIX, parserFactoryTriX);
        RDFParserRegistry.registerLangTriples(Lang.RDFNULL, parserFactoryRDFNULL);
        RDFParserRegistry.registerLangQuads(Lang.JSONLD, parserFactoryJsonLD);
        RDFParserRegistry.registerLangQuads(Lang.NQUADS, parserFactory);
        RDFParserRegistry.registerLangQuads(Lang.TRIG, parserFactory);
        RDFParserRegistry.registerLangQuads(Lang.RDFTHRIFT, parserFactoryThrift);
        RDFParserRegistry.registerLangQuads(Lang.TRIX, parserFactoryTriX);
        RDFParserRegistry.registerLangQuads(Lang.RDFNULL, parserFactoryRDFNULL);
    }

    private static void registerLang(Lang lang, ReaderRIOTFactory factory) {
        RDFLanguages.register(lang);
        langToParserFactory.put(lang, factory);
    }

    public static void registerLangTriples(Lang lang, ReaderRIOTFactory factory) {
        langTriples.add(lang);
        RDFParserRegistry.registerLang(lang, factory);
    }

    public static void registerLangQuads(Lang lang, ReaderRIOTFactory factory) {
        langQuads.add(lang);
        RDFParserRegistry.registerLang(lang, factory);
    }

    public static void removeRegistration(Lang lang) {
        RDFLanguages.unregister(lang);
        langToParserFactory.remove(lang);
    }

    @Deprecated
    public static ReaderRIOTFactory getFactory(Lang language) {
        return langToParserFactory.get(language);
    }

    public static boolean isRegistered(Lang lang) {
        return langToParserFactory.containsKey(lang);
    }

    public static boolean isTriples(Lang lang) {
        return langTriples.contains(lang);
    }

    public static boolean isQuads(Lang lang) {
        return langQuads.contains(lang);
    }

    static {
        RDFParserRegistry.init();
    }

    private static class ReaderRDFThrift
    implements ReaderRIOT {
        private final ParserProfile profile;

        public ReaderRDFThrift(ParserProfile profile2) {
            this.profile = profile2;
        }

        @Override
        public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
            try {
                BinRDF.inputStreamToStream(in, output);
            }
            catch (RiotThriftException ex) {
                if (this.profile != null && this.profile.getErrorHandler() != null) {
                    this.profile.getErrorHandler().error(ex.getMessage(), -1L, -1L);
                } else {
                    ErrorHandlerFactory.errorHandlerStd.error(ex.getMessage(), -1L, -1L);
                }
                throw ex;
            }
        }

        @Override
        public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context2) {
            throw new RiotException("RDF Thrift : Reading binary data from a java.io.reader is not supported. Please use an InputStream");
        }
    }

    private static class ReaderRIOTFactoryThrift
    implements ReaderRIOTFactory {
        private ReaderRIOTFactoryThrift() {
        }

        @Override
        public ReaderRIOT create(Lang language, ParserProfile profile2) {
            return new ReaderRDFThrift(profile2);
        }
    }

    private static class ReaderRIOTFactoryJSONLD
    implements ReaderRIOTFactory {
        private ReaderRIOTFactoryJSONLD() {
        }

        @Override
        public ReaderRIOT create(Lang language, ParserProfile profile2) {
            if (!Lang.JSONLD.equals(language)) {
                throw new InternalErrorException("Attempt to parse " + language + " as JSON-LD");
            }
            return new JsonLDReader(language, profile2, profile2.getErrorHandler());
        }
    }

    private static class ReaderRIOTLang
    implements ReaderRIOT {
        private final Lang lang;
        private ParserProfile parserProfile = null;

        ReaderRIOTLang(Lang lang, ParserProfile parserProfile) {
            this.lang = lang;
            this.parserProfile = parserProfile;
        }

        @Override
        public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
            LangRIOT parser = RiotParsers.createParser(in, this.lang, output, this.parserProfile);
            parser.parse();
        }

        @Override
        public void read(Reader in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
            LangRIOT parser = RiotParsers.createParser(in, this.lang, output, this.parserProfile);
            parser.parse();
        }
    }

    private static class ReaderRIOTLangFactory
    implements ReaderRIOTFactory {
        private ReaderRIOTLangFactory() {
        }

        @Override
        public ReaderRIOT create(Lang lang, ParserProfile parserProfile) {
            return new ReaderRIOTLang(lang, parserProfile);
        }
    }
}

