/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.lang.LangNTuple;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LangNTriples
extends LangNTuple<Triple> {
    private static Logger messageLog = LoggerFactory.getLogger("N-Triples");

    public LangNTriples(Tokenizer tokens, ParserProfile profile2, StreamRDF dest) {
        super(tokens, profile2, dest);
    }

    @Override
    public Lang getLang() {
        return RDFLanguages.NTRIPLES;
    }

    @Override
    protected final void runParser() {
        while (this.hasNext()) {
            Triple x = this.parseOne();
            if (x == null) continue;
            this.dest.triple(x);
        }
    }

    @Override
    protected final Triple parseOne() {
        Triple triple = this.parseTriple();
        Token x = this.nextToken();
        if (x.getType() != TokenType.DOT) {
            this.exception(x, "Triple not terminated by DOT: %s", x);
        }
        return triple;
    }

    @Override
    protected final Node tokenAsNode(Token token) {
        return this.profile.create(null, token);
    }
}

