/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import org.apache.jena.atlas.io.PeekReader;
import org.apache.jena.atlas.json.io.parser.TokenizerJSON;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.lang.LangNQuads;
import org.apache.jena.riot.lang.LangNTriples;
import org.apache.jena.riot.lang.LangRDFJSON;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.lang.LangTriG;
import org.apache.jena.riot.lang.LangTurtle;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.apache.jena.sparql.core.Quad;

public class RiotParsers {
    private RiotParsers() {
    }

    public static LangRIOT createParser(InputStream input, Lang lang, StreamRDF dest, ParserProfile profile2) {
        if (RDFLanguages.sameLang(RDFLanguages.RDFJSON, lang)) {
            TokenizerJSON tokenizer = new TokenizerJSON(PeekReader.makeUTF8(input));
            return RiotParsers.createParserRdfJson(tokenizer, dest, profile2);
        }
        Tokenizer tokenizer = TokenizerText.create().source(input).errorHandler(profile2.getErrorHandler()).build();
        if (RDFLanguages.sameLang(RDFLanguages.TURTLE, lang) || RDFLanguages.sameLang(RDFLanguages.N3, lang)) {
            return RiotParsers.createParserTurtle(tokenizer, dest, profile2);
        }
        if (RDFLanguages.sameLang(RDFLanguages.NTRIPLES, lang)) {
            return RiotParsers.createParserNTriples(tokenizer, dest, profile2);
        }
        if (RDFLanguages.sameLang(RDFLanguages.NQUADS, lang)) {
            return RiotParsers.createParserNQuads(tokenizer, dest, profile2);
        }
        if (RDFLanguages.sameLang(RDFLanguages.TRIG, lang)) {
            return RiotParsers.createParserTriG(tokenizer, dest, profile2);
        }
        return null;
    }

    public static LangRIOT createParser(Reader input, Lang lang, StreamRDF dest, ParserProfile profile2) {
        if (RDFLanguages.sameLang(RDFLanguages.RDFJSON, lang)) {
            TokenizerJSON tokenizer = new TokenizerJSON(PeekReader.make(input));
            return RiotParsers.createParserRdfJson(tokenizer, dest, profile2);
        }
        Tokenizer tokenizer = TokenizerText.create().source(input).errorHandler(profile2.getErrorHandler()).build();
        if (RDFLanguages.sameLang(RDFLanguages.TURTLE, lang) || RDFLanguages.sameLang(RDFLanguages.N3, lang)) {
            return RiotParsers.createParserTurtle(tokenizer, dest, profile2);
        }
        if (RDFLanguages.sameLang(RDFLanguages.NTRIPLES, lang)) {
            return RiotParsers.createParserNTriples(tokenizer, dest, profile2);
        }
        if (RDFLanguages.sameLang(RDFLanguages.NQUADS, lang)) {
            return RiotParsers.createParserNQuads(tokenizer, dest, profile2);
        }
        if (RDFLanguages.sameLang(RDFLanguages.TRIG, lang)) {
            return RiotParsers.createParserTriG(tokenizer, dest, profile2);
        }
        return null;
    }

    public static LangNTriples createParserNTriples(Tokenizer tokenizer, StreamRDF dest, ParserProfile profile2) {
        LangNTriples parser = new LangNTriples(tokenizer, profile2, dest);
        return parser;
    }

    public static LangNQuads createParserNQuads(Tokenizer tokenizer, StreamRDF dest, ParserProfile profile2) {
        LangNQuads parser = new LangNQuads(tokenizer, profile2, dest);
        return parser;
    }

    static LangTurtle createParserTurtle(Tokenizer tokenizer, StreamRDF dest, ParserProfile profile2) {
        LangTurtle parser = new LangTurtle(tokenizer, profile2, dest);
        return parser;
    }

    static LangTriG createParserTriG(Tokenizer tokenizer, StreamRDF dest, ParserProfile profile2) {
        LangTriG parser = new LangTriG(tokenizer, profile2, dest);
        return parser;
    }

    static LangRDFJSON createParserRdfJson(Tokenizer tokenizer, StreamRDF dest, ParserProfile profile2) {
        LangRDFJSON parser = new LangRDFJSON(tokenizer, profile2, dest);
        return parser;
    }

    public static Iterator<Triple> createIteratorNTriples(InputStream input, StreamRDF dest) {
        return RiotParsers.createIteratorNTriples(input, dest, RiotLib.dftProfile());
    }

    public static Iterator<Triple> createIteratorNTriples(InputStream input, StreamRDF dest, ParserProfile profile2) {
        Tokenizer tokenizer = TokenizerText.create().source(input).errorHandler(profile2.getErrorHandler()).build();
        return RiotParsers.createParserNTriples(tokenizer, null, profile2);
    }

    public static Iterator<Quad> createIteratorNQuads(InputStream input, StreamRDF dest) {
        return RiotParsers.createIteratorNQuads(input, dest, RiotLib.dftProfile());
    }

    public static Iterator<Quad> createIteratorNQuads(InputStream input, StreamRDF dest, ParserProfile profile2) {
        Tokenizer tokenizer = TokenizerText.create().source(input).errorHandler(profile2.getErrorHandler()).build();
        return RiotParsers.createParserNQuads(tokenizer, null, profile2);
    }
}

