/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.util.EqualityTest;
import org.apache.jena.sparql.util.Iso;

public class IsoAlg {
    public static boolean DEBUG = false;
    private static final IndentedWriter out = new IndentedWriter(System.out);

    public static boolean isIsomorphic(Collection<Tuple<Node>> x1, Collection<Tuple<Node>> x2, EqualityTest nodeTest) {
        return IsoAlg.isIsomorphic(x1, x2, Iso.mappableBlankNodes, nodeTest);
    }

    public static boolean isIsomorphic(Collection<Tuple<Node>> x1, Collection<Tuple<Node>> x2, Iso.Mappable mappable, EqualityTest nodeTest) {
        return IsoAlg.matcher(x1, x2, Mapping.rootMapping, mappable, nodeTest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean matcher(Collection<Tuple<Node>> tuples1, Collection<Tuple<Node>> tuples2, Mapping mapping, Iso.Mappable mappable, EqualityTest nodeTest) {
        if (DEBUG) {
            out.println("match: ");
            out.println("  1: " + tuples1);
            out.println("  2: " + tuples2);
            out.println("  M: " + mapping);
        }
        if (tuples1.size() != tuples2.size()) {
            return false;
        }
        tuples2 = new ArrayList<Tuple<Node>>(tuples2);
        Iterator<Tuple<Node>> iterator = (tuples1 = new ArrayList<Tuple<Node>>(tuples1)).iterator();
        if (iterator.hasNext()) {
            Tuple<Node> t1 = iterator.next();
            if (DEBUG) {
                out.println("  Process t1 = " + t1);
            }
            tuples1.remove(t1);
            List<Possibility> causes = IsoAlg.matcher(t1, tuples2, mapping, mappable, nodeTest);
            if (DEBUG) {
                out.println("    Possibilities: Tuple" + t1 + " :: " + causes);
            }
            out.incIndent();
            try {
                for (Possibility c : causes) {
                    if (DEBUG) {
                        out.println("  Try: " + c);
                    }
                    Tuple<Node> t2 = c.tuple;
                    tuples2.remove(t2);
                    if (tuples1.isEmpty() && tuples2.isEmpty()) {
                        boolean bl = true;
                        return bl;
                    }
                    if (IsoAlg.matcher(tuples1, tuples2, c.mapping, mappable, nodeTest)) {
                        if (DEBUG) {
                            out.println("Yes");
                        }
                        boolean bl = true;
                        return bl;
                    }
                    if (DEBUG) {
                        out.println("No");
                    }
                    tuples2.add(t2);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                out.decIndent();
            }
        }
        return true;
    }

    private static List<Possibility> matcher(Tuple<Node> t1, Collection<Tuple<Node>> g2, Mapping mapping, Iso.Mappable mappable, EqualityTest nodeTest) {
        ArrayList<Possibility> matches = new ArrayList<Possibility>();
        for (Tuple<Node> t2 : g2) {
            Mapping step = IsoAlg.gen(t1, t2, mapping, mappable, nodeTest);
            if (step == null) continue;
            Possibility c = new Possibility(t2, step);
            matches.add(c);
        }
        return matches;
    }

    private static Mapping gen(Tuple<Node> t1, Tuple<Node> t2, Mapping _mapping, Iso.Mappable mappable, EqualityTest nodeTest) {
        if (t1.len() != t2.len()) {
            return null;
        }
        Mapping mapping = _mapping;
        for (int i = 0; i < t1.len(); ++i) {
            Node n1 = t1.get(i);
            Node n2 = t2.get(i);
            Node n1m = mapping.map(n1);
            if (n1m != null) {
                if (n1m.equals(n2)) continue;
                return null;
            }
            if (mappable.mappable(n1, n2)) {
                if (mapping.reverseMapped(n2)) {
                    return null;
                }
                mapping = new Mapping(mapping, n1, n2);
                continue;
            }
            if (nodeTest.equal(n1, n2)) continue;
            return null;
        }
        return mapping;
    }

    static {
        out.setFlushOnNewline(true);
    }

    static class Possibility {
        final Tuple<Node> tuple;
        final Mapping mapping;

        public Possibility(Tuple<Node> tuple, Mapping mapping) {
            this.tuple = tuple;
            this.mapping = mapping;
        }

        public String toString() {
            return String.format("Poss|%s %s|", this.tuple, this.mapping);
        }
    }

    static class Mapping {
        final Node node1;
        final Node node2;
        final Mapping parent;
        static Mapping rootMapping = new Mapping(null, null, null);

        public Mapping(Mapping parent, Node node1, Node node2) {
            this.parent = parent;
            this.node1 = node1;
            this.node2 = node2;
        }

        public boolean mapped(Node node) {
            return this.map(node) != null;
        }

        public Node map(Node node) {
            Mapping mapping = this;
            while (mapping != rootMapping) {
                if (mapping.node1.equals(node)) {
                    return mapping.node2;
                }
                mapping = mapping.parent;
            }
            return null;
        }

        public boolean reverseMapped(Node node) {
            return this.reverseMap(node) != null;
        }

        public Node reverseMap(Node node) {
            Mapping mapping = this;
            while (mapping != rootMapping) {
                if (mapping.node2.equals(node)) {
                    return mapping.node1;
                }
                mapping = mapping.parent;
            }
            return null;
        }

        public String toString() {
            StringBuilder sbuff = new StringBuilder();
            Mapping mapping = this;
            while (mapping != rootMapping) {
                sbuff.append("{" + mapping.node1 + " => " + mapping.node2 + "}");
                mapping = mapping.parent;
            }
            sbuff.append("{}");
            return sbuff.toString();
        }
    }
}

