/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.graph;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.util.graph.Findable;

public class FindableCollection
implements Findable {
    private Collection<Triple> triples;

    public FindableCollection(Collection<Triple> triples) {
        this.triples = triples;
    }

    @Override
    public Iterator<Triple> find(Node _s, Node _p, Node _o) {
        Node s2 = FindableCollection.m(_s);
        Node p = FindableCollection.m(_p);
        Node o = FindableCollection.m(_o);
        return Iter.filter(this.triples.iterator(), t -> FindableCollection.matches(t, s2, p, o));
    }

    static Node m(Node n) {
        return n == Node.ANY ? null : n;
    }

    static boolean matches(Triple t, Node s2, Node p, Node o) {
        if (s2 != null && !Objects.equals(s2, t.getSubject())) {
            return false;
        }
        if (p != null && !Objects.equals(p, t.getPredicate())) {
            return false;
        }
        return o == null || Objects.equals(o, t.getObject());
    }

    @Override
    public boolean contains(Node s2, Node p, Node o) {
        if (s2 == Node.ANY) {
            s2 = null;
        }
        if (p == Node.ANY) {
            p = null;
        }
        if (o == Node.ANY) {
            o = null;
        }
        for (Triple t : this.triples) {
            if (!FindableCollection.matches(t, s2, p, o)) continue;
            return true;
        }
        return false;
    }
}

