/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Node;
import com.github.benmanes.caffeine.cache.PW;
import com.github.benmanes.caffeine.cache.UnsafeAccess;
import java.lang.ref.ReferenceQueue;

class PWR<K, V>
extends PW<K, V> {
    protected static final long WRITE_TIME_OFFSET = UnsafeAccess.objectFieldOffset(PWR.class, "writeTime");
    volatile long writeTime;

    PWR() {
    }

    PWR(K key, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now2) {
        super(key, keyReferenceQueue, value, valueReferenceQueue, weight, now2);
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, now2);
    }

    PWR(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now2) {
        super(keyReference, value, valueReferenceQueue, weight, now2);
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, now2);
    }

    @Override
    public final long getWriteTime() {
        return UnsafeAccess.UNSAFE.getLong(this, WRITE_TIME_OFFSET);
    }

    @Override
    public final void setWriteTime(long writeTime) {
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, writeTime);
    }

    @Override
    public final boolean casWriteTime(long expect, long update) {
        return this.writeTime == expect && UnsafeAccess.UNSAFE.compareAndSwapLong(this, WRITE_TIME_OFFSET, expect, update);
    }

    @Override
    public Node<K, V> newNode(K key, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now2) {
        return new PWR<K, V>(key, keyReferenceQueue, value, valueReferenceQueue, weight, now2);
    }

    @Override
    public Node<K, V> newNode(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now2) {
        return new PWR<K, V>(keyReference, value, valueReferenceQueue, weight, now2);
    }
}

