/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.api;

import edu.wisc.library.ocfl.api.OcflConfig;
import edu.wisc.library.ocfl.api.OcflObjectUpdater;
import edu.wisc.library.ocfl.api.OcflOption;
import edu.wisc.library.ocfl.api.model.FileChangeHistory;
import edu.wisc.library.ocfl.api.model.ObjectDetails;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.OcflObjectVersion;
import edu.wisc.library.ocfl.api.model.ValidationResults;
import edu.wisc.library.ocfl.api.model.VersionDetails;
import edu.wisc.library.ocfl.api.model.VersionInfo;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.stream.Stream;

public interface OcflRepository {
    public ObjectVersionId putObject(ObjectVersionId var1, Path var2, VersionInfo var3, OcflOption ... var4);

    public ObjectVersionId updateObject(ObjectVersionId var1, VersionInfo var2, Consumer<OcflObjectUpdater> var3);

    public void getObject(ObjectVersionId var1, Path var2);

    public OcflObjectVersion getObject(ObjectVersionId var1);

    public ObjectDetails describeObject(String var1);

    public VersionDetails describeVersion(ObjectVersionId var1);

    public FileChangeHistory fileChangeHistory(String var1, String var2);

    public boolean containsObject(String var1);

    public Stream<String> listObjectIds();

    public void purgeObject(String var1);

    public ValidationResults validateObject(String var1, boolean var2);

    public ObjectVersionId replicateVersionAsHead(ObjectVersionId var1, VersionInfo var2);

    public void rollbackToVersion(ObjectVersionId var1);

    public void exportVersion(ObjectVersionId var1, Path var2, OcflOption ... var3);

    public void exportObject(String var1, Path var2, OcflOption ... var3);

    public void importVersion(Path var1, OcflOption ... var2);

    public void importObject(Path var1, OcflOption ... var2);

    public void close();

    public OcflConfig config();

    public void invalidateCache(String var1);

    public void invalidateCache();
}

