/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.validation.model;

import edu.wisc.library.ocfl.core.validation.model.SimpleUser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SimpleVersion {
    public static final String CREATED_KEY = "created";
    public static final String MESSAGE_KEY = "message";
    public static final String USER_KEY = "user";
    public static final String STATE_KEY = "state";
    private String created;
    private String message;
    private SimpleUser user;
    private Map<String, List<String>> state;
    private Map<String, String> invertedState;

    public SimpleVersion() {
    }

    public SimpleVersion(String created, String message, SimpleUser user, Map<String, List<String>> state) {
        this.created = created;
        this.message = message;
        this.user = user;
        this.state = state;
    }

    public String getCreated() {
        return this.created;
    }

    public SimpleVersion setCreated(String created) {
        this.created = created;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public SimpleVersion setMessage(String message) {
        this.message = message;
        return this;
    }

    public SimpleUser getUser() {
        return this.user;
    }

    public SimpleVersion setUser(SimpleUser user) {
        this.user = user;
        return this;
    }

    public Map<String, List<String>> getState() {
        return this.state;
    }

    public SimpleVersion setState(Map<String, List<String>> state) {
        this.state = state;
        return this;
    }

    public Map<String, String> getInvertedState() {
        if (this.invertedState == null && this.state != null) {
            this.invertedState = this.invertMap(this.state);
        }
        return this.invertedState;
    }

    private Map<String, String> invertMap(Map<String, List<String>> original) {
        HashMap<String, String> inverted = new HashMap<String, String>(original.size());
        original.forEach((key, values) -> values.forEach(value -> inverted.put((String)value, (String)key)));
        return inverted;
    }

    public String toString() {
        return "SimpleVersion{created='" + this.created + "', message='" + this.message + "', user=" + this.user + ", state=" + this.state + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleVersion that = (SimpleVersion)o;
        return Objects.equals(this.created, that.created) && Objects.equals(this.message, that.message) && Objects.equals(this.user, that.user) && Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.message, this.user, this.state);
    }
}

