/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import java.util.List;
import java.util.function.Function;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Content;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.assemblers.ContentAssembler;
import org.apache.jena.assembler.assemblers.PrefixMappingAssembler;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.vocabulary.RDF;

public abstract class ModelAssembler
extends AssemblerBase
implements Assembler {
    protected abstract Model openEmptyModel(Assembler var1, Resource var2, Mode var3);

    protected Model openModel(Assembler a, Resource root2, Content initial, Mode mode) {
        Model m3 = this.openEmptyModel(a, root2, mode);
        if (!initial.isEmpty()) {
            this.addContent(root2, m3, initial);
        }
        return m3;
    }

    private static void exec(Model m3, Resource root2, Runnable action) {
        boolean b = m3.supportsTransactions();
        if (b) {
            m3.begin();
        }
        try {
            action.run();
            if (b) {
                m3.commit();
            }
        }
        catch (Throwable t) {
            if (b) {
                m3.abort();
            }
            throw t;
        }
    }

    @Override
    public Object open(Assembler a, Resource root2, Mode mode) {
        Model m3 = this.openModel(a, root2, this.getInitialContent(a, root2), mode);
        ModelAssembler.exec(m3, root2, () -> {
            this.addContent(root2, m3, this.getContent(a, root2));
            this.addPrefixes(m3, a, root2);
        });
        return m3;
    }

    protected void addContent(Resource root2, Model m3, Content c) {
        c.fill(m3);
    }

    protected void addPrefixes(Model m3, Assembler a, Resource root2) {
        m3.setNsPrefixes(this.getPrefixMapping(a, root2));
    }

    private PrefixMapping getPrefixMapping(Assembler a, Resource root2) {
        return PrefixMappingAssembler.getPrefixes(a, root2, PrefixMapping.Factory.create());
    }

    @Override
    public Model openModel(Resource root2, Mode mode) {
        return (Model)this.open(this, root2, mode);
    }

    protected Content getInitialContent(Assembler a, Resource root2) {
        Model partial = ModelFactory.createDefaultModel();
        Resource combined = partial.createResource();
        StmtIterator it = root2.listProperties(JA.initialContent);
        while (it.hasNext()) {
            this.transferContentProperties(partial, it.nextStatement().getResource(), combined);
        }
        return this.contentFromModel(a, root2, partial, combined);
    }

    private Content contentFromModel(Assembler a, Resource root2, Model partial, Resource combined) {
        return partial.isEmpty() ? Content.empty : (Content)a.open(this.completedClone(root2, combined, partial));
    }

    protected Content getContent(Assembler a, Resource root2) {
        Resource newRoot = this.oneLevelClone(root2);
        Model fragment = newRoot.getModel();
        return fragment.isEmpty() ? Content.empty : (Content)a.open(a, this.completedClone(root2, newRoot, fragment));
    }

    private Resource completedClone(Resource root2, Resource newRoot, Model fragment) {
        Model typed = fragment.add(newRoot, RDF.type, JA.Content);
        return newRoot.inModel(ModelFactory.createUnion(root2.getModel(), typed));
    }

    private Resource oneLevelClone(Resource root2) {
        Model partialCopy = ModelFactory.createDefaultModel();
        Resource newRoot = partialCopy.createResource();
        this.transferContentProperties(partialCopy, root2, newRoot);
        return newRoot;
    }

    private void transferContentProperties(Model partial, Resource someInitial, Resource combined) {
        for (Property contentProperty : ContentAssembler.contentProperties) {
            partial.add(this.copyProperties(someInitial, this.replaceSubjectMap(partial, combined), contentProperty));
        }
    }

    private List<Statement> copyProperties(Resource root2, Function<Statement, Statement> replace, Property property) {
        return root2.listProperties(property).mapWith(replace).toList();
    }

    private Function<Statement, Statement> replaceSubjectMap(Model inModel, Resource newSubject) {
        return s2 -> inModel.createStatement(newSubject, s2.getPredicate(), s2.getObject());
    }
}

