/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.Bytes;

public class Hex {
    public static int formatUnsignedLongHex(byte[] b, int start, long value, int width) {
        int idx = start + width - 1;
        int w = width;
        long x = value;
        while (w > 0) {
            byte ch;
            int d = (int)(x & 0xFL);
            b[idx] = ch = Bytes.hexDigitsUC[d];
            --w;
            --idx;
            if ((x >>>= 4) != 0L) continue;
            break;
        }
        if (x != 0L) {
            throw new AtlasException("formatUnsignedLongHex: overflow");
        }
        while (w > 0) {
            b[idx] = 48;
            --idx;
            --w;
        }
        return width;
    }

    public static long getLong(byte[] arr, int idx) {
        long x = 0L;
        for (int i = 0; i < 16; ++i) {
            byte c = arr[idx];
            int v = Hex.hexByteToInt(c);
            x = x << 4 | (long)v;
            ++idx;
        }
        return x;
    }

    public static int hexByteToInt(int c) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (65 <= c && c <= 70) {
            return c - 65 + 10;
        }
        if (97 <= c && c <= 102) {
            return c - 97 + 10;
        }
        String msg = String.format("Bad hex char : %d (0x%02X)", c, c);
        throw new IllegalArgumentException(msg);
    }

    public static int hexByteToInt(int c, int marker) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (65 <= c && c <= 70) {
            return c - 65 + 10;
        }
        if (97 <= c && c <= 102) {
            return c - 97 + 10;
        }
        return marker;
    }

    public static int hexStringToInt(String s2, int i, int len) {
        int x = 0;
        for (int j = i; j < i + len; ++j) {
            char ch = s2.charAt(j);
            int k = 0;
            switch (ch) {
                case '0': {
                    k = 0;
                    break;
                }
                case '1': {
                    k = 1;
                    break;
                }
                case '2': {
                    k = 2;
                    break;
                }
                case '3': {
                    k = 3;
                    break;
                }
                case '4': {
                    k = 4;
                    break;
                }
                case '5': {
                    k = 5;
                    break;
                }
                case '6': {
                    k = 6;
                    break;
                }
                case '7': {
                    k = 7;
                    break;
                }
                case '8': {
                    k = 8;
                    break;
                }
                case '9': {
                    k = 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    k = 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    k = 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    k = 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    k = 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    k = 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    k = 15;
                    break;
                }
                default: {
                    throw new AtlasException("Illegal hex escape: " + ch);
                }
            }
            x = (x << 4) + k;
        }
        return x;
    }
}

