/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web;

import org.apache.jena.web.HttpSC;

public class HttpException
extends RuntimeException {
    private int statusCode = -1;
    private String statusLine = null;
    private String response;

    public HttpException(int statusCode, String statusLine, String response) {
        super(HttpException.exMessage(statusCode, statusLine));
        this.statusCode = statusCode;
        this.statusLine = statusLine;
        this.response = response;
    }

    private static String exMessage(int statusCode, String statusLine) {
        if (statusLine == null) {
            statusLine = HttpSC.getMessage(statusCode);
        }
        return statusCode + " - " + HttpSC.getMessage(statusCode);
    }

    public HttpException(String message) {
        super(message);
    }

    public HttpException(String message, Throwable cause) {
        super(message, cause);
    }

    public HttpException(Throwable cause) {
        super(cause);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Deprecated
    public int getResponseCode() {
        return this.getStatusCode();
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    public String getResponse() {
        return this.response;
    }
}

