/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.IDN;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIComponents;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;
import org.apache.jena.iri.ViolationCodes;
import org.apache.jena.iri.impl.AbsIRIImpl;
import org.apache.jena.iri.impl.IDNP;
import org.apache.jena.iri.impl.IRIFactoryImpl;
import org.apache.jena.iri.impl.IRIImpl;
import org.apache.jena.iri.impl.Lexer;
import org.apache.jena.iri.impl.LexerFragment;
import org.apache.jena.iri.impl.LexerHost;
import org.apache.jena.iri.impl.LexerPath;
import org.apache.jena.iri.impl.LexerPort;
import org.apache.jena.iri.impl.LexerQuery;
import org.apache.jena.iri.impl.LexerScheme;
import org.apache.jena.iri.impl.LexerUserinfo;
import org.apache.jena.iri.impl.LexerXHost;

public class Parser
implements IRIComponents,
ViolationCodes {
    static Lexer[][] lexers;
    static int nextLexer;
    static boolean DEBUG;
    static final int[] fields;
    static final int[] invFields;
    static final Pattern p;
    final Matcher m;
    final String uri;
    int found;
    final long[] errors = new long[fields.length];
    IRIImpl iri;

    public Parser(String uri, IRIImpl iri) {
        this.uri = uri;
        this.iri = iri;
        this.m = p.matcher(uri);
        if (!this.m.matches()) {
            throw new RuntimeException("not meant to happen");
        }
        Lexer[] lex = Parser.nextLexer();
        IRIFactoryImpl factory = iri.getFactory();
        iri.scheme = !this.has(2) ? factory.noScheme() : factory.getScheme(this.get(2).toLowerCase(), this);
        for (int i = 0; i < lex.length - 1; ++i) {
            int range = fields[i];
            if (!this.has(range)) continue;
            if (range != 11 && range != 7 || this.start(range) != this.end(range)) {
                this.found |= 1 << range;
            }
            lex[i].analyse(this, range);
            iri.scheme.analyse(this, range);
            if (range != 10) continue;
            try {
                int port = Integer.parseInt(this.get(10));
                if (iri.scheme.port() == port) {
                    this.recordError(10, 13);
                }
                if (port >= 1024 || port < 0) continue;
                this.recordError(10, 14);
                continue;
            }
            catch (Exception port) {
                // empty catch block
            }
        }
        if (this.has(4)) {
            this.found |= 0x10;
        }
        iri.scheme.analyse(this, 31);
        if ((this.errors[invFields[7]] & 0x80500000L) != 0L) {
            String h2 = this.get(7);
            try {
                try {
                    IDN.toUnicode(IDNP.toASCII(h2, 2), 3);
                }
                catch (IllegalArgumentException e2) {
                    try {
                        IDN.toUnicode(IDNP.toASCII(h2, 3), 3);
                        this.recordError(7, 34, e2);
                    }
                    catch (IllegalArgumentException e1) {
                        this.recordError(7, 35, e2);
                    }
                }
            }
            catch (IndexOutOfBoundsException e3) {
                this.recordError(7, 35, e3);
            }
        }
        this.hasComponents(~this.found & iri.scheme.getRequired(), 57);
        this.hasComponents(this.found & iri.scheme.getProhibited(), 58);
    }

    private static Lexer[] nextLexer() {
        Lexer[] lex = lexers[nextLexer];
        nextLexer = (nextLexer + 1) % lexers.length;
        return lex;
    }

    static LexerHost hostLexer() {
        return (LexerHost)Parser.nextLexer()[2];
    }

    private void hasComponents(int errorComponents, int eCode) {
        if (errorComponents == 0) {
            return;
        }
        int i = 0;
        while (errorComponents != 0) {
            if ((errorComponents & 1) == 1) {
                this.recordError(i, eCode);
            }
            ++i;
            errorComponents >>= 1;
        }
    }

    public boolean has(int f) {
        return this.m.start(f) != -1;
    }

    public int start(int f) {
        return this.m.start(f == 31 ? 11 : f);
    }

    public int end(int f) {
        if (f != 31) {
            return this.m.end(f);
        }
        return this.has(13) ? this.end(13) : this.end(11);
    }

    public String get(int f) {
        if (f != 31) {
            return this.m.group(f);
        }
        return this.uri.substring(this.start(11), this.end(31));
    }

    private static void show(IRI iri) {
        System.out.println("Scheme: " + iri.getScheme());
        System.out.println("Authority: " + iri.getRawAuthority());
        System.out.println("User: " + iri.getRawUserinfo());
        System.out.println("Host: " + iri.getRawHost());
        System.out.println("Port: " + iri.getPort());
        System.out.println("Path: " + iri.getRawPath());
        System.out.println("Query: " + iri.getRawQuery());
        System.out.println("Fragment: " + iri.getRawFragment());
        Iterator<Violation> it = ((AbsIRIImpl)iri).allViolations();
        while (it.hasNext()) {
            System.out.println(it.next().getLongMessage());
        }
        it = ((AbsIRIImpl)iri).violations(true);
        while (it.hasNext()) {
            System.out.println("+" + it.next().getLongMessage());
        }
        it = ((AbsIRIImpl)iri).violations(false);
        while (it.hasNext()) {
            System.out.println("++" + it.next().getLongMessage());
        }
    }

    public static void devParse(String uriStr) throws IOException {
        LineNumberReader in = new LineNumberReader(new StringReader(uriStr));
        Parser.devParse(in);
    }

    public static void main(String[] args) throws IOException {
        LineNumberReader in = new LineNumberReader(new InputStreamReader(System.in));
        Parser.devParse(in);
    }

    private static void devParse(LineNumberReader in) throws IOException {
        IRIImpl last = null;
        DEBUG = true;
        IRIFactory factory = IRIFactory.iriImplementation();
        String s2;
        while ((s2 = in.readLine()) != null) {
            if ((s2 = s2.trim()).equals("quit")) {
                return;
            }
            IRIImpl iri = (IRIImpl)factory.create(s2);
            Parser.show(iri);
            if (last != null) {
                IRI r = last.create(iri);
                System.out.println("Resolved: " + r.toString());
                Parser.show(r);
            }
            last = iri;
        }
        return;
    }

    public void recordError(int range, int e2) {
        int n = invFields[range];
        this.errors[n] = this.errors[n] | 1L << e2;
        this.iri.allErrors |= 1L << e2;
    }

    public void recordError(int range, int e2, Exception ex) {
        int n = invFields[range];
        this.errors[n] = this.errors[n] | 1L << e2;
        this.iri.allErrors |= 1L << e2;
        this.iri.idnaException = ex;
    }

    long errors(int r) {
        return this.errors[invFields[r]];
    }

    public void matchedRule(int range, int rule) {
        if (DEBUG) {
            System.err.println("Rule " + rule + " in range " + range);
        }
    }

    public void matchedRule(int range, int rule, String string) {
        if (DEBUG) {
            System.err.println("Rule " + rule + " in range " + range + " yytext: '" + string + "'");
        }
    }

    static {
        int i;
        lexers = new Lexer[8][];
        for (i = 0; i < lexers.length; ++i) {
            Parser.lexers[i] = new Lexer[]{new LexerScheme((Reader)null), new LexerUserinfo((Reader)null), new LexerHost((Reader)null), new LexerPort((Reader)null), new LexerPath((Reader)null), new LexerQuery((Reader)null), new LexerFragment((Reader)null), new LexerXHost((Reader)null)};
        }
        nextLexer = 0;
        DEBUG = false;
        fields = new int[]{2, 6, 7, 10, 11, 13, 15, 4, 31};
        invFields = new int[32];
        for (i = 0; i < invFields.length; ++i) {
            Parser.invFields[i] = -1;
        }
        for (i = 0; i < fields.length; ++i) {
            Parser.invFields[Parser.fields[i]] = i;
        }
        p = Pattern.compile("(([^:/?#]*):)?(//((([^/?#@]*)@)?(\\[[^/?#]*\\]|([^/?#:]*))?(:([^/?#]*))?))?([^#?]*)?(\\?([^#]*))?(#(.*))?", 32);
    }
}

