/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import java.util.Iterator;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.EnumeratedClass;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.ontology.Profile;
import org.apache.jena.ontology.impl.OntClassImpl;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;

public class EnumeratedClassImpl
extends OntClassImpl
implements EnumeratedClass {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new EnumeratedClassImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to EnumeratedClass");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile2 = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile2 != null && profile2.isSupported(node, eg, OntClass.class) && eg.asGraph().contains(node, profile2.ONE_OF().asNode(), Node.ANY);
        }
    };

    public EnumeratedClassImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public void setOneOf(RDFList en) {
        this.setPropertyValue(this.getProfile().ONE_OF(), "ONE_OF", en);
    }

    @Override
    public void addOneOf(Resource res) {
        this.addListPropertyValue(this.getProfile().ONE_OF(), "ONE_OF", res);
    }

    @Override
    public void addOneOf(Iterator<? extends Resource> individuals) {
        while (individuals.hasNext()) {
            this.addOneOf(individuals.next());
        }
    }

    @Override
    public RDFList getOneOf() {
        return this.objectAs(this.getProfile().ONE_OF(), "ONE_OF", RDFList.class);
    }

    @Override
    public ExtendedIterator<? extends OntResource> listOneOf() {
        return this.getOneOf().iterator().mapWith(n -> n.as(OntResource.class));
    }

    @Override
    public boolean hasOneOf(Resource res) {
        return this.getOneOf().contains(res);
    }

    @Override
    public void removeOneOf(Resource res) {
        this.setOneOf(this.getOneOf().remove(res));
    }
}

