/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.MaxCardinalityQRestriction;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.Profile;
import org.apache.jena.ontology.impl.QualifiedRestrictionImpl;

public class MaxCardinalityQRestrictionImpl
extends QualifiedRestrictionImpl
implements MaxCardinalityQRestriction {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new MaxCardinalityQRestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to MaxCardinalityQRestriction");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            return MaxCardinalityQRestrictionImpl.isMaxCardinalityQRestriction(node, eg);
        }
    };

    public static boolean isMaxCardinalityQRestriction(Node node, EnhGraph eg) {
        Profile profile2 = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
        return profile2 != null && profile2.isSupported(node, eg, MaxCardinalityQRestriction.class);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && MaxCardinalityQRestrictionImpl.isMaxCardinalityQRestriction(this.asNode(), this.getGraph());
    }

    public MaxCardinalityQRestrictionImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public void setMaxCardinalityQ(int cardinality) {
        this.setPropertyValue(this.getProfile().MAX_CARDINALITY_Q(), "MAX_CARDINALITY_Q", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public int getMaxCardinalityQ() {
        return this.objectAsInt(this.getProfile().MAX_CARDINALITY_Q(), "MAX_CARDINALITY_Q");
    }

    @Override
    public boolean hasMaxCardinalityQ(int cardinality) {
        return this.hasPropertyValue(this.getProfile().MAX_CARDINALITY_Q(), "MAX_CARDINALITY_Q", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public void removeMaxCardinalityQ(int cardinality) {
        this.removePropertyValue(this.getProfile().MAX_CARDINALITY_Q(), "MAX_CARDINALITY_Q", this.getModel().createTypedLiteral(cardinality));
    }
}

