/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.io.Printable;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryType;
import org.apache.jena.query.QueryVisitor;
import org.apache.jena.query.SortCondition;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.algebra.table.TableData;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.QueryCompare;
import org.apache.jena.sparql.core.QueryHashCode;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarAlloc;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.serializer.QuerySerializerFactory;
import org.apache.jena.sparql.serializer.SerializerRegistry;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformCopyBase;
import org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformApplyElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sys.JenaSystem;

public class Query
extends Prologue
implements Cloneable,
Printable {
    public static final int QueryTypeUnknown = -123;
    public static final int QueryTypeSelect = 111;
    public static final int QueryTypeConstruct = 222;
    public static final int QueryTypeDescribe = 333;
    public static final int QueryTypeAsk = 444;
    public static final int QueryTypeJson = 555;
    private QueryType queryType = QueryType.UNKNOWN;
    private List<String> graphURIs = new ArrayList<String>();
    private List<String> namedGraphURIs = new ArrayList<String>();
    private Element queryPattern = null;
    private Syntax syntax = Syntax.syntaxSPARQL;
    public static final long NOLIMIT = Long.MIN_VALUE;
    private long resultLimit = Long.MIN_VALUE;
    private long resultOffset = Long.MIN_VALUE;
    private List<SortCondition> orderBy = null;
    public static final int ORDER_ASCENDING = 1;
    public static final int ORDER_DESCENDING = -1;
    public static final int ORDER_DEFAULT = -2;
    public static final int ORDER_UNKNOW = -3;
    protected TableData valuesDataBlock = null;
    protected boolean strictQuery = true;
    protected boolean queryResultStar = false;
    protected boolean distinct = false;
    protected boolean reduced = false;
    protected Template constructTemplate = null;
    protected List<Node> resultNodes = new ArrayList<Node>();
    private VarAlloc varAlloc = new VarAlloc(".");
    protected VarExprList projectVars = new VarExprList();
    protected VarExprList groupVars = new VarExprList();
    protected List<Expr> havingExprs = new ArrayList<Expr>();
    private Map<String, Node> jsonMapping = new LinkedHashMap<String, Node>();
    private List<ExprAggregator> aggregators = new ArrayList<ExprAggregator>();
    private Map<Var, ExprAggregator> aggregatorsMap = new HashMap<Var, ExprAggregator>();
    private Map<String, Var> aggregatorsAllocated = new HashMap<String, Var>();
    private boolean resultVarsSet = false;
    private int hashcode = -1;

    public Query() {
        this.syntax = Syntax.syntaxSPARQL;
    }

    public Query(Prologue prologue) {
        this();
        Prologue p2 = prologue.copy();
        this.prefixMap = p2.getPrefixMapping();
        this.seenBaseURI = false;
        this.resolver = p2.getResolver();
    }

    private Var allocInternVar() {
        return this.varAlloc.allocVar();
    }

    public void setQuerySelectType() {
        this.queryType = QueryType.SELECT;
    }

    public void setQueryConstructType() {
        this.queryType = QueryType.CONSTRUCT;
        this.queryResultStar = true;
    }

    public void setQueryDescribeType() {
        this.queryType = QueryType.DESCRIBE;
    }

    public void setQueryAskType() {
        this.queryType = QueryType.ASK;
    }

    public void setQueryJsonType() {
        this.queryType = QueryType.CONSTRUCT_JSON;
    }

    public QueryType queryType() {
        return this.queryType;
    }

    @Deprecated
    public int getQueryType() {
        switch (this.queryType) {
            case SELECT: {
                return 111;
            }
            case ASK: {
                return 444;
            }
            case CONSTRUCT: {
                return 222;
            }
            case CONSTRUCT_JSON: {
                return 555;
            }
            case CONSTRUCT_QUADS: {
                return 222;
            }
            case DESCRIBE: {
                return 333;
            }
        }
        return -123;
    }

    public boolean isSelectType() {
        return this.queryType == QueryType.SELECT;
    }

    public boolean isConstructType() {
        return this.queryType == QueryType.CONSTRUCT;
    }

    public boolean isDescribeType() {
        return this.queryType == QueryType.DESCRIBE;
    }

    public boolean isAskType() {
        return this.queryType == QueryType.ASK;
    }

    public boolean isJsonType() {
        return this.queryType == QueryType.CONSTRUCT_JSON;
    }

    public boolean isUnknownType() {
        return this.queryType == QueryType.UNKNOWN;
    }

    public boolean isConstructQuad() {
        return this.isConstructType() && this.constructTemplate.containsRealQuad() || this.queryType == QueryType.CONSTRUCT_QUADS;
    }

    public Prologue getPrologue() {
        return this;
    }

    public void setStrict(boolean isStrict) {
        this.strictQuery = isStrict;
        if (this.strictQuery) {
            this.initStrict();
        } else {
            this.initLax();
        }
    }

    public boolean isStrict() {
        return this.strictQuery;
    }

    private void initStrict() {
    }

    private void initLax() {
    }

    public void setDistinct(boolean b) {
        this.distinct = b;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setReduced(boolean b) {
        this.reduced = b;
    }

    public boolean isReduced() {
        return this.reduced;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public void setSyntax(Syntax syntax) {
        this.syntax = syntax;
        if (syntax != Syntax.syntaxSPARQL) {
            this.strictQuery = false;
        }
    }

    public long getLimit() {
        return this.resultLimit;
    }

    public void setLimit(long limit) {
        this.resultLimit = limit;
    }

    public boolean hasLimit() {
        return this.resultLimit != Long.MIN_VALUE;
    }

    public long getOffset() {
        return this.resultOffset;
    }

    public void setOffset(long offset) {
        this.resultOffset = offset;
    }

    public boolean hasOffset() {
        return this.resultOffset != Long.MIN_VALUE;
    }

    public boolean hasOrderBy() {
        return this.orderBy != null && this.orderBy.size() > 0;
    }

    public boolean isOrdered() {
        return this.hasOrderBy();
    }

    public void addOrderBy(SortCondition condition) {
        if (this.orderBy == null) {
            this.orderBy = new ArrayList<SortCondition>();
        }
        this.orderBy.add(condition);
    }

    public void addOrderBy(Expr expr, int direction) {
        SortCondition sc = new SortCondition(expr, direction);
        this.addOrderBy(sc);
    }

    public void addOrderBy(Node var, int direction) {
        if (!var.isVariable()) {
            throw new QueryException("Not a variable: " + var);
        }
        SortCondition sc = new SortCondition(var, direction);
        this.addOrderBy(sc);
    }

    public void addOrderBy(String varName, int direction) {
        varName = Var.canonical(varName);
        SortCondition sc = new SortCondition(new ExprVar(varName), direction);
        this.addOrderBy(sc);
    }

    public List<SortCondition> getOrderBy() {
        return this.orderBy;
    }

    public boolean isQueryResultStar() {
        return this.queryResultStar;
    }

    public void setQueryResultStar(boolean isQueryStar) {
        this.queryResultStar = isQueryStar;
        if (isQueryStar) {
            this.resultVarsSet = false;
        }
    }

    public void setQueryPattern(Element elt) {
        this.queryPattern = elt;
    }

    public Element getQueryPattern() {
        return this.queryPattern;
    }

    public void addGraphURI(String s2) {
        if (this.graphURIs == null) {
            this.graphURIs = new ArrayList<String>();
        }
        this.graphURIs.add(s2);
    }

    public void addNamedGraphURI(String uri) {
        if (this.namedGraphURIs == null) {
            this.namedGraphURIs = new ArrayList<String>();
        }
        if (this.namedGraphURIs.contains(uri)) {
            throw new QueryException("URI already in named graph set: " + uri);
        }
        this.namedGraphURIs.add(uri);
    }

    public List<String> getGraphURIs() {
        return this.graphURIs;
    }

    public boolean usesGraphURI(String uri) {
        return this.graphURIs.contains(uri);
    }

    public List<String> getNamedGraphURIs() {
        return this.namedGraphURIs;
    }

    public boolean usesNamedGraphURI(String uri) {
        return this.namedGraphURIs.contains(uri);
    }

    public boolean hasDatasetDescription() {
        if (this.getGraphURIs() != null && this.getGraphURIs().size() > 0) {
            return true;
        }
        return this.getNamedGraphURIs() != null && this.getNamedGraphURIs().size() > 0;
    }

    public DatasetDescription getDatasetDescription() {
        if (!this.hasDatasetDescription()) {
            return null;
        }
        DatasetDescription description = new DatasetDescription();
        description.addAllDefaultGraphURIs(this.getGraphURIs());
        description.addAllNamedGraphURIs(this.getNamedGraphURIs());
        return description;
    }

    public List<String> getResultVars() {
        this.setResultVars();
        return Var.varNames(this.projectVars.getVars());
    }

    public List<Var> getProjectVars() {
        this.setResultVars();
        return this.projectVars.getVars();
    }

    public VarExprList getProject() {
        return this.projectVars;
    }

    public void addProjectVars(Collection<?> vars) {
        for (Object obj : vars) {
            if (obj instanceof String) {
                this.addResultVar((String)obj);
                continue;
            }
            if (obj instanceof Var) {
                this.addResultVar((Var)obj);
                continue;
            }
            throw new QueryException("Not a variable or variable name: " + obj);
        }
        this.resultVarsSet = true;
    }

    public void addResultVar(String varName) {
        varName = Var.canonical(varName);
        this._addResultVar(varName);
    }

    public void addResultVar(Node v) {
        if (!v.isVariable()) {
            throw new QueryException("Not a variable: " + v);
        }
        this._addResultVar(v.getName());
    }

    public void addResultVar(Node v, Expr expr) {
        Var var = null;
        if (v == null) {
            var = this.allocInternVar();
        } else {
            if (!v.isVariable()) {
                throw new QueryException("Not a variable: " + v);
            }
            var = Var.alloc(v);
        }
        Query._addVarExpr(this.projectVars, var, expr);
    }

    public void addResultVar(Expr expr) {
        Query._addVarExpr(this.projectVars, this.allocInternVar(), expr);
    }

    public void addResultVar(String varName, Expr expr) {
        Var var = null;
        if (varName == null) {
            var = this.allocInternVar();
        } else {
            varName = Var.canonical(varName);
            var = Var.alloc(varName);
        }
        Query._addVarExpr(this.projectVars, var, expr);
    }

    private void _addResultVar(String varName) {
        Var v = Var.alloc(varName);
        Query._addVar(this.projectVars, v);
        this.resultVarsSet = true;
    }

    private static void _addVar(VarExprList varExprList, Var v) {
        if (varExprList.contains(v)) {
            Expr expr = varExprList.getExpr(v);
            if (expr != null) {
                throw new QueryBuildException("Duplicate variable (had an expression) in result projection '" + v + "'");
            }
            return;
        }
        varExprList.add(v);
    }

    private static void _addVarExpr(VarExprList varExprList, Var v, Expr expr) {
        if (varExprList.contains(v)) {
            throw new QueryBuildException("Duplicate variable in result projection '" + v + "'");
        }
        varExprList.add(v, expr);
    }

    public boolean hasGroupBy() {
        return !this.groupVars.isEmpty() || this.getAggregators().size() > 0;
    }

    public boolean hasHaving() {
        return this.havingExprs != null && this.havingExprs.size() > 0;
    }

    public VarExprList getGroupBy() {
        return this.groupVars;
    }

    public List<Expr> getHavingExprs() {
        return this.havingExprs;
    }

    public void addGroupBy(String varName) {
        varName = Var.canonical(varName);
        this.addGroupBy(Var.alloc(varName));
    }

    public void addGroupBy(Node v) {
        Query._addVar(this.groupVars, Var.alloc(v));
    }

    public void addGroupBy(Expr expr) {
        this.addGroupBy(null, expr);
    }

    public void addGroupBy(Var v, Expr expr) {
        if (v == null) {
            v = this.allocInternVar();
        }
        if (expr.isVariable() && v.isAllocVar()) {
            this.addGroupBy(expr.asVar());
            return;
        }
        this.groupVars.add(v, expr);
    }

    public void addHavingCondition(Expr expr) {
        this.havingExprs.add(expr);
    }

    public void addJsonMapping(String key, Node value) {
        this.jsonMapping.put(key, value);
    }

    public Map<String, Node> getJsonMapping() {
        return Collections.unmodifiableMap(this.jsonMapping);
    }

    public boolean hasAggregators() {
        return this.aggregators.size() != 0;
    }

    public List<ExprAggregator> getAggregators() {
        return this.aggregators;
    }

    public Expr allocAggregate(Aggregator agg) {
        String key = agg.key();
        Var v = this.aggregatorsAllocated.get(key);
        if (v != null) {
            ExprAggregator eAgg = this.aggregatorsMap.get(v);
            if (!agg.equals(eAgg.getAggregator())) {
                Log.warn(Query.class, "Internal inconsistency: Aggregator: " + agg);
            }
            return eAgg;
        }
        v = this.allocInternVar();
        ExprAggregator aggExpr = new ExprAggregator(v, agg);
        this.aggregatorsAllocated.put(key, v);
        this.aggregatorsMap.put(v, aggExpr);
        this.aggregators.add(aggExpr);
        return aggExpr;
    }

    public boolean hasValues() {
        return this.valuesDataBlock != null;
    }

    public List<Var> getValuesVariables() {
        return this.valuesDataBlock == null ? null : this.valuesDataBlock.getVars();
    }

    public List<Binding> getValuesData() {
        return this.valuesDataBlock == null ? null : this.valuesDataBlock.getRows();
    }

    public void setValuesDataBlock(List<Var> variables, List<Binding> values) {
        Query.checkDataBlock(variables, values);
        this.valuesDataBlock = new TableData(variables, values);
    }

    private static void checkDataBlock(List<Var> variables, List<Binding> values) {
        int N = variables.size();
        for (Binding valueRow : values) {
            Iterator<Var> iter = valueRow.vars();
            while (iter.hasNext()) {
                Var v = iter.next();
                if (variables.contains(v)) continue;
                throw new QueryBuildException("Variable " + v + " not found in " + variables);
            }
        }
    }

    public Template getConstructTemplate() {
        return this.constructTemplate;
    }

    public void setConstructTemplate(Template templ) {
        this.constructTemplate = templ;
    }

    public void addDescribeNode(Node node) {
        if (node.isVariable()) {
            this.addResultVar(node);
            return;
        }
        if (node.isURI() || node.isBlank()) {
            if (!this.resultNodes.contains(node)) {
                this.resultNodes.add(node);
            }
            return;
        }
        if (node.isLiteral()) {
            throw new QueryException("Result node is a literal: " + FmtUtils.stringForNode(node));
        }
        throw new QueryException("Result node not recognized: " + node);
    }

    public List<Node> getResultURIs() {
        return this.resultNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultVars() {
        if (this.resultVarsSet) {
            return;
        }
        Query query = this;
        synchronized (query) {
            if (this.resultVarsSet) {
                return;
            }
            this.resetResultVars();
            this.resultVarsSet = true;
        }
    }

    public void resetResultVars() {
        if (this.isQueryResultStar()) {
            this.projectVars.clear();
        }
        if (this.getQueryPattern() == null) {
            if (!this.isDescribeType()) {
                Log.warn(this, "setResultVars(): no query pattern");
            }
            return;
        }
        if (this.isSelectType()) {
            if (this.isQueryResultStar()) {
                this.findAndAddNamedVars();
            }
            return;
        }
        if (this.isConstructType()) {
            this.findAndAddNamedVars();
            return;
        }
        if (this.isDescribeType()) {
            if (this.isQueryResultStar()) {
                this.findAndAddNamedVars();
            }
            return;
        }
    }

    private void findAndAddNamedVars() {
        Iterator<Var> varIter = null;
        if (this.hasGroupBy()) {
            varIter = this.groupVars.getVars().iterator();
        } else {
            LinkedHashSet<Var> queryVars = new LinkedHashSet<Var>();
            PatternVars.vars(queryVars, this.getQueryPattern());
            if (this.hasValues()) {
                queryVars.addAll(this.getValuesVariables());
            }
            varIter = queryVars.iterator();
        }
        while (varIter.hasNext()) {
            Var var = varIter.next();
            if (!var.isNamedVar()) continue;
            this.addResultVar(var);
        }
    }

    public void visit(QueryVisitor visitor) {
        visitor.startVisit(this);
        visitor.visitResultForm(this);
        visitor.visitPrologue(this);
        if (this.isSelectType()) {
            visitor.visitSelectResultForm(this);
        }
        if (this.isConstructType()) {
            visitor.visitConstructResultForm(this);
        }
        if (this.isDescribeType()) {
            visitor.visitDescribeResultForm(this);
        }
        if (this.isAskType()) {
            visitor.visitAskResultForm(this);
        }
        if (this.isJsonType()) {
            visitor.visitJsonResultForm(this);
        }
        visitor.visitDatasetDecl(this);
        visitor.visitQueryPattern(this);
        visitor.visitGroupBy(this);
        visitor.visitHaving(this);
        visitor.visitOrderBy(this);
        visitor.visitOffset(this);
        visitor.visitLimit(this);
        visitor.visitValues(this);
        visitor.finishVisit(this);
    }

    public Object clone() {
        return this.cloneQuery();
    }

    public Query cloneQuery() {
        ElementTransformCopyBase eltTransform = new ElementTransformCopyBase(true);
        ExprTransformApplyElementTransform exprTransform = new ExprTransformApplyElementTransform(eltTransform, true);
        Query result = QueryTransformOps.transform(this, eltTransform, exprTransform);
        return result;
    }

    public String toString() {
        return this.serialize();
    }

    public String toString(Syntax syntax) {
        return this.serialize(syntax);
    }

    public int hashCode() {
        if (this.hashcode == -1) {
            this.hashcode = QueryHashCode.calc(this);
            if (this.hashcode == -1) {
                this.hashcode = -1073741824;
            }
        }
        return this.hashcode;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Query)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return QueryCompare.equals(this, (Query)other);
    }

    @Override
    public void output(IndentedWriter out) {
        this.serialize(out);
    }

    public String serialize() {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        this.serialize(buff);
        return buff.toString();
    }

    public String serialize(Syntax syntax) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        this.serialize(buff, syntax);
        return buff.toString();
    }

    public void serialize(OutputStream out) {
        this.serialize(out, this.syntax);
    }

    public void serialize(OutputStream out, Syntax syntax) {
        IndentedWriter writer = new IndentedWriter(out);
        this.serialize(writer, syntax);
        writer.flush();
        try {
            out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void serialize(IndentedLineBuffer buff) {
        this.serialize(buff, this.syntax);
    }

    public void serialize(IndentedLineBuffer buff, Syntax outSyntax) {
        this.serialize((IndentedWriter)buff, outSyntax);
    }

    public void serialize(IndentedWriter writer) {
        this.serialize(writer, this.syntax);
    }

    public void serialize(IndentedWriter writer, Syntax outSyntax) {
        QuerySerializerFactory factory = SerializerRegistry.get().getQuerySerializerFactory(outSyntax);
        QueryVisitor serializer = factory.create(outSyntax, this, writer);
        this.visit(serializer);
    }

    static {
        JenaSystem.init();
    }
}

