/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.process.inf;

import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.process.inf.InferenceSetupRDFS;
import org.apache.jena.vocabulary.RDF;

abstract class InferenceProcessorRDFS {
    static final Node rdfType = RDF.type.asNode();
    private final InferenceSetupRDFS state;

    public InferenceProcessorRDFS(InferenceSetupRDFS state) {
        this.state = state;
    }

    public void process(Node s2, Node p, Node o) {
        this.subClass(s2, p, o);
        this.subProperty(s2, p, o);
        this.domain(s2, p, o);
        this.range(s2, p, o);
    }

    public abstract void derive(Node var1, Node var2, Node var3);

    private final void subClass(Node s2, Node p, Node o) {
        List<Node> x;
        if (p.equals(rdfType) && (x = this.state.transClasses.get(o)) != null) {
            for (Node c : x) {
                this.derive(s2, p, c);
            }
        }
    }

    private void subProperty(Node s2, Node p, Node o) {
        List<Node> x = this.state.transProperties.get(p);
        if (x != null) {
            for (Node p2 : x) {
                this.derive(s2, p2, o);
            }
        }
    }

    private final void domain(Node s2, Node p, Node o) {
        List<Node> x = this.state.domainList.get(p);
        if (x != null) {
            for (Node c : x) {
                this.derive(s2, rdfType, c);
                this.subClass(s2, rdfType, c);
            }
        }
    }

    private final void range(Node s2, Node p, Node o) {
        if (o.isLiteral()) {
            return;
        }
        List<Node> x = this.state.rangeList.get(p);
        if (x != null) {
            for (Node c : x) {
                this.derive(o, rdfType, c);
                this.subClass(o, rdfType, c);
            }
        }
    }
}

