/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.mgt;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.engine.QueryEngineBase;
import org.apache.jena.sparql.mgt.ContextMBean;
import org.apache.jena.sparql.mgt.QueryEngineInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ARQMgt_X {
    private static Logger log = LoggerFactory.getLogger(ARQMgt_X.class);
    private static boolean initialized = false;
    private static boolean noJMX = false;
    private static Map<ObjectName, Object> mgtObjects = new HashMap<ObjectName, Object>();
    private static MBeanServer mbs = null;

    ARQMgt_X() {
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (noJMX) {
            return;
        }
        try {
            mbs = ManagementFactory.getPlatformMBeanServer();
        }
        catch (Throwable ex) {
            Log.debug(ARQMgt_X.class, "Failed to initialize JMX: " + ex.getMessage());
            noJMX = true;
            mbs = null;
        }
    }

    public static void register() {
        ARQMgt_X.init();
        String NS = "org.apache.jena.arq";
        ContextMBean cxtBean = new ContextMBean(ARQ.getContext());
        QueryEngineInfo qeInfo = QueryEngineBase.queryEngineInfo;
        ARQMgt_X.register(NS + ".system:type=Context", (Object)cxtBean);
        ARQMgt_X.register(NS + ".system:type=Engine", (Object)qeInfo);
    }

    public static void register(String name, Object bean2) {
        ARQMgt_X.init();
        if (noJMX) {
            return;
        }
        ObjectName objName = ARQMgt_X.objectName(name);
        ARQMgt_X.register(objName, bean2);
    }

    public static void unregister(String name) {
        ARQMgt_X.init();
        if (noJMX) {
            return;
        }
        ObjectName objName = ARQMgt_X.objectName(name);
        ARQMgt_X.unregister(objName);
    }

    private static void register(ObjectName objName, Object bean2) {
        try {
            if (mbs.isRegistered(objName)) {
                try {
                    mbs.unregisterMBean(objName);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    // empty catch block
                }
            }
            log.debug("Register MBean: " + objName);
            mbs.registerMBean(bean2, objName);
            mgtObjects.put(objName, bean2);
        }
        catch (NotCompliantMBeanException ex) {
            log.warn("Failed to register (NotCompliantMBeanException)'" + objName.getCanonicalName() + "': " + ex.getMessage());
            throw new ARQException("Failed to register '" + objName.getCanonicalName() + "': " + ex.getMessage(), ex);
        }
        catch (InstanceAlreadyExistsException ex) {
            log.warn("Failed to register (InstanceAlreadyExistsException)'" + objName.getCanonicalName() + "': " + ex.getMessage());
            throw new ARQException("Failed to register '" + objName.getCanonicalName() + "': " + ex.getMessage(), ex);
        }
        catch (MBeanRegistrationException ex) {
            log.warn("Failed to register (MBeanRegistrationException)'" + objName.getCanonicalName() + "': " + ex.getMessage());
            throw new ARQException("Failed to register '" + objName.getCanonicalName() + "': " + ex.getMessage(), ex);
        }
    }

    private static void unregister(ObjectName objName) {
        log.debug("Unregister MBean: " + objName);
        if (!mgtObjects.containsKey(objName)) {
            log.warn("MBean not already registered: " + objName);
        }
        try {
            mbs.unregisterMBean(objName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (MBeanRegistrationException ex) {
            throw new InternalErrorException(ex);
        }
    }

    private static ObjectName objectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException ex) {
            throw new ARQException("Failed to create name '" + name + "': " + ex.getMessage(), ex);
        }
    }
}

