/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify.request;

import java.util.Iterator;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.modify.request.UpdateDataWriter;
import org.apache.jena.sparql.modify.request.UpdateSerializer;
import org.apache.jena.sparql.modify.request.UpdateVisitor;
import org.apache.jena.sparql.modify.request.UpdateWriterVisitor;
import org.apache.jena.sparql.serializer.PrologueSerializer;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.NodeToLabelMap;
import org.apache.jena.sparql.util.NodeToLabelMapBNode;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateRequest;

public class UpdateWriter
implements UpdateSerializer {
    protected final IndentedWriter out;
    protected final SerializationContext sCxt;
    protected UpdateDataWriter udw;
    protected boolean firstOp = true;
    protected boolean opened = false;

    public UpdateWriter(IndentedWriter out, SerializationContext sCxt) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (sCxt == null) {
            sCxt = new SerializationContext((Prologue)null, (NodeToLabelMap)new NodeToLabelMapBNode());
        }
        this.out = out;
        this.sCxt = sCxt;
    }

    @Override
    public void open() {
        if (null != this.sCxt) {
            this.prologue();
        }
        this.opened = true;
    }

    protected void checkOpen() {
        if (!this.opened) {
            throw new IllegalStateException("UpdateStreamWriter is not opened.  Call open() first.");
        }
    }

    protected void prologue() {
        int row1 = this.out.getRow();
        PrologueSerializer.output(this.out, this.sCxt.getPrologue());
        int row2 = this.out.getRow();
        if (row1 != row2) {
            this.out.newline();
        }
    }

    protected void prepareForDataUpdate(UpdateDataWriter.UpdateMode mode) {
        if (null != this.udw && !this.udw.getMode().equals((Object)mode)) {
            this.udw.close();
            this.udw = null;
            this.firstOp = false;
        }
        if (null == this.udw) {
            if (!this.firstOp) {
                this.out.println(" ;");
            }
            this.udw = new UpdateDataWriter(mode, this.out, this.sCxt);
            this.udw.open();
            this.firstOp = false;
        }
    }

    public void insert(Quad quad) {
        this.insert(quad.getGraph(), quad.asTriple());
    }

    public void insert(Iterator<? extends Quad> it) {
        this.checkOpen();
        this.prepareForDataUpdate(UpdateDataWriter.UpdateMode.INSERT);
        while (it.hasNext()) {
            this.udw.send(it.next());
        }
    }

    public void insert(Node graph, Triple triple) {
        this.checkOpen();
        this.prepareForDataUpdate(UpdateDataWriter.UpdateMode.INSERT);
        this.udw.send(graph, triple);
    }

    public void insert(Node graph, Iterator<? extends Triple> it) {
        this.checkOpen();
        this.prepareForDataUpdate(UpdateDataWriter.UpdateMode.INSERT);
        while (it.hasNext()) {
            this.udw.send(graph, it.next());
        }
    }

    public void delete(Quad quad) {
        this.delete(quad.getGraph(), quad.asTriple());
    }

    public void delete(Iterator<? extends Quad> it) {
        this.checkOpen();
        this.prepareForDataUpdate(UpdateDataWriter.UpdateMode.DELETE);
        while (it.hasNext()) {
            this.udw.send(it.next());
        }
    }

    public void delete(Node graph, Triple triple) {
        this.checkOpen();
        this.prepareForDataUpdate(UpdateDataWriter.UpdateMode.DELETE);
        this.udw.send(graph, triple);
    }

    public void delete(Node graph, Iterator<? extends Triple> it) {
        this.checkOpen();
        this.prepareForDataUpdate(UpdateDataWriter.UpdateMode.DELETE);
        while (it.hasNext()) {
            this.udw.send(graph, it.next());
        }
    }

    @Override
    public void update(Update update) {
        this.checkOpen();
        if (null != this.udw) {
            this.udw.close();
            this.udw = null;
        }
        if (!this.firstOp) {
            this.out.println(" ;");
        }
        UpdateVisitor writer = this.prepareWriterVisitor();
        update.visit(writer);
        this.firstOp = false;
    }

    protected UpdateVisitor prepareWriterVisitor() {
        return new UpdateWriterVisitor(this.out, this.sCxt);
    }

    @Override
    public void update(Iterable<? extends Update> updates) {
        this.update(updates.iterator());
    }

    @Override
    public void update(Iterator<? extends Update> updateIter) {
        while (updateIter.hasNext()) {
            this.update(updateIter.next());
        }
    }

    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() {
        if (this.opened) {
            if (null != this.udw) {
                this.udw.close();
                this.udw = null;
            }
            this.out.ensureStartOfLine();
            this.flush();
            this.opened = false;
        }
    }

    public static void output(UpdateRequest request, IndentedWriter out) {
        Prologue prologue = request;
        if (!request.explicitlySetBaseURI()) {
            prologue = new Prologue(request.getPrefixMapping(), (IRIResolver)null);
        }
        SerializationContext sCxt = new SerializationContext(prologue, (NodeToLabelMap)new NodeToLabelMapBNode());
        UpdateWriter.output(request, out, sCxt);
    }

    public static void output(UpdateRequest request, IndentedWriter out, SerializationContext sCxt) {
        UpdateWriter uw = new UpdateWriter(out, sCxt);
        uw.open();
        uw.update(request);
        uw.close();
    }

    public static void output(Update update, IndentedWriter out, SerializationContext sCxt) {
        UpdateWriter uw = new UpdateWriter(out, sCxt);
        uw.open();
        uw.update(update);
        uw.close();
    }
}

