/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.pfunction.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterConcat;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.engine.iterator.QueryIterTriplePattern;
import org.apache.jena.sparql.engine.iterator.QueryIterYieldN;
import org.apache.jena.sparql.pfunction.PFuncSimple;
import org.apache.jena.sparql.util.IterLib;
import org.apache.jena.sparql.util.graph.GraphContainerUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;

public class container
extends PFuncSimple {
    Node typeNode = null;

    public container() {
        this.typeNode = null;
    }

    protected container(Node typeURI) {
        this.typeNode = typeURI;
    }

    @Override
    public QueryIterator execEvaluated(Binding binding, Node containerNode, Node predicate, Node member, ExecutionContext execCxt) {
        QueryIterator qIter1 = this.execEvaluatedConcrete(binding, containerNode, predicate, member, execCxt);
        QueryIterator qIter2 = this.execEvaluatedCalc(binding, containerNode, predicate, member, execCxt);
        QueryIterConcat concat2 = new QueryIterConcat(execCxt);
        concat2.add(qIter1);
        concat2.add(qIter2);
        return concat2;
    }

    private QueryIterator execEvaluatedConcrete(Binding binding, Node containerNode, Node predicate, Node member, ExecutionContext execCxt) {
        QueryIterSingleton input = QueryIterSingleton.create(binding, execCxt);
        Graph graph = execCxt.getActiveGraph();
        QueryIterTriplePattern qIter = new QueryIterTriplePattern(input, new Triple(containerNode, predicate, member), execCxt);
        return qIter;
    }

    private QueryIterator execEvaluatedCalc(Binding binding, Node containerNode, Node predicate, Node member, ExecutionContext execCxt) {
        Graph graph = execCxt.getActiveGraph();
        if (!containerNode.isVariable()) {
            if (!GraphContainerUtils.isContainer(execCxt.getActiveGraph(), containerNode, this.typeNode)) {
                return IterLib.noResults(execCxt);
            }
            return this.oneContainer(binding, containerNode, member, execCxt);
        }
        Collection<Node> c = null;
        c = member.isVariable() ? container.findContainers(graph, this.typeNode) : container.findContainingContainers(graph, this.typeNode, member);
        QueryIterConcat cIter = new QueryIterConcat(execCxt);
        Var cVar = Var.alloc(containerNode);
        for (Node cn : c) {
            Binding b = BindingFactory.binding(binding, cVar, cn);
            Node m3 = member;
            if (Var.isVar(member) && member.equals(cVar)) {
                m3 = cn;
            }
            cIter.add(this.oneContainer(b, cn, m3, execCxt));
        }
        return cIter;
    }

    private QueryIterator oneContainer(Binding binding, Node containerNode, Node member, ExecutionContext execCxt) {
        if (member.isVariable()) {
            return this.members(binding, containerNode, Var.alloc(member), execCxt);
        }
        return this.verify(binding, containerNode, member, execCxt);
    }

    private QueryIterator members(Binding binding, Node containerNode, Var memberVar, ExecutionContext execCxt) {
        Collection<Node> x = GraphContainerUtils.containerMembers(execCxt.getActiveGraph(), containerNode, this.typeNode);
        if (x == null) {
            return IterLib.noResults(execCxt);
        }
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (Node n : x) {
            Binding b = BindingFactory.binding(binding, memberVar, n);
            bindings.add(b);
        }
        return new QueryIterPlainWrapper(bindings.iterator(), execCxt);
    }

    private QueryIterator verify(Binding binding, Node containerNode, Node member, ExecutionContext execCxt) {
        int count = GraphContainerUtils.countContainerMember(execCxt.getActiveGraph(), containerNode, this.typeNode, member);
        return new QueryIterYieldN(count, binding, execCxt);
    }

    private static Collection<Node> findContainers(Graph graph, Node typeNode) {
        HashSet<Node> acc = new HashSet<Node>();
        if (typeNode != null) {
            container.findContainers(acc, graph, typeNode);
            return acc;
        }
        container.findContainers(acc, graph, RDF.Bag.asNode());
        container.findContainers(acc, graph, RDF.Seq.asNode());
        container.findContainers(acc, graph, RDF.Alt.asNode());
        return acc;
    }

    private static void findContainers(Collection<Node> acc, Graph graph, Node typeNode) {
        ExtendedIterator<Triple> iter = graph.find(Node.ANY, RDF.type.asNode(), typeNode);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            Node containerNode = t.getSubject();
            acc.add(containerNode);
        }
    }

    private static Collection<Node> findContainingContainers(Graph graph, Node typeNode, Node member) {
        HashSet<Node> acc = new HashSet<Node>();
        ExtendedIterator<Triple> iter = graph.find(Node.ANY, Node.ANY, member);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            Node containerNode = t.getSubject();
            if (!GraphContainerUtils.isContainer(graph, containerNode, typeNode)) continue;
            acc.add(containerNode);
        }
        return acc;
    }
}

