/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.MutableBits;

public final class Lucene50LiveDocsFormat
extends LiveDocsFormat {
    private static final String EXTENSION = "liv";
    private static final String CODEC_NAME = "Lucene50LiveDocs";
    private static final int VERSION_START = 0;
    private static final int VERSION_CURRENT = 0;

    @Override
    public MutableBits newLiveDocs(int size) throws IOException {
        FixedBitSet bits = new FixedBitSet(size);
        bits.set(0, size);
        return bits;
    }

    @Override
    public MutableBits newLiveDocs(Bits existing) throws IOException {
        FixedBitSet fbs = (FixedBitSet)existing;
        return fbs.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bits readLiveDocs(Directory dir, SegmentCommitInfo info, IOContext context2) throws IOException {
        block21: {
            long gen = info.getDelGen();
            String name = IndexFileNames.fileNameFromGeneration(info.info.name, EXTENSION, gen);
            int length = info.info.maxDoc();
            Throwable throwable = null;
            try (ChecksumIndexInput input = dir.openChecksumInput(name, context2);){
                FixedBitSet fixedBitSet;
                Throwable priorE = null;
                try {
                    CodecUtil.checkIndexHeader(input, CODEC_NAME, 0, 0, info.info.getId(), Long.toString(gen, 36));
                    long[] data = new long[FixedBitSet.bits2words(length)];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = input.readLong();
                    }
                    FixedBitSet fbs = new FixedBitSet(data, length);
                    if (fbs.length() - fbs.cardinality() != info.getDelCount()) {
                        throw new CorruptIndexException("bits.deleted=" + (fbs.length() - fbs.cardinality()) + " info.delcount=" + info.getDelCount(), input);
                    }
                    fixedBitSet = fbs;
                }
                catch (Throwable exception) {
                    try {
                        try {
                            priorE = exception;
                        }
                        catch (Throwable throwable2) {
                            CodecUtil.checkFooter(input, priorE);
                            throw throwable2;
                        }
                        CodecUtil.checkFooter(input, priorE);
                        break block21;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
                CodecUtil.checkFooter(input, priorE);
                return fixedBitSet;
            }
        }
        throw new AssertionError();
    }

    @Override
    public void writeLiveDocs(MutableBits bits, Directory dir, SegmentCommitInfo info, int newDelCount, IOContext context2) throws IOException {
        long gen = info.getNextDelGen();
        String name = IndexFileNames.fileNameFromGeneration(info.info.name, EXTENSION, gen);
        FixedBitSet fbs = (FixedBitSet)bits;
        if (fbs.length() - fbs.cardinality() != info.getDelCount() + newDelCount) {
            throw new CorruptIndexException("bits.deleted=" + (fbs.length() - fbs.cardinality()) + " info.delcount=" + info.getDelCount() + " newdelcount=" + newDelCount, name);
        }
        long[] data = fbs.getBits();
        try (IndexOutput output = dir.createOutput(name, context2);){
            CodecUtil.writeIndexHeader(output, CODEC_NAME, 0, info.info.getId(), Long.toString(gen, 36));
            for (int i = 0; i < data.length; ++i) {
                output.writeLong(data[i]);
            }
            CodecUtil.writeFooter(output);
        }
    }

    @Override
    public void files(SegmentCommitInfo info, Collection<String> files) throws IOException {
        if (info.hasDeletions()) {
            files.add(IndexFileNames.fileNameFromGeneration(info.info.name, EXTENSION, info.getDelGen()));
        }
    }
}

