/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.search.spans.TermSpans;

public class SpanTermQuery
extends SpanQuery {
    protected final Term term;
    protected final TermContext termContext;
    private static final float PHRASE_TO_SPAN_TERM_POSITIONS_COST = 4.0f;
    private static final int TERM_POSNS_SEEK_OPS_PER_DOC = 128;
    private static final int TERM_OPS_PER_POS = 7;

    public SpanTermQuery(Term term) {
        this.term = Objects.requireNonNull(term);
        this.termContext = null;
    }

    public SpanTermQuery(Term term, TermContext context2) {
        this.term = Objects.requireNonNull(term);
        this.termContext = context2;
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public String getField() {
        return this.term.field();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        IndexReaderContext topContext = searcher.getTopReaderContext();
        TermContext context2 = this.termContext == null || !this.termContext.wasBuiltFor(topContext) ? TermContext.build(topContext, this.term) : this.termContext;
        return new SpanTermWeight(context2, searcher, needsScores ? Collections.singletonMap(this.term, context2) : null, boost);
    }

    static float termPositionsCost(TermsEnum termsEnum) throws IOException {
        int docFreq = termsEnum.docFreq();
        assert (docFreq > 0);
        long totalTermFreq = termsEnum.totalTermFreq();
        float expOccurrencesInMatchingDoc = totalTermFreq < (long)docFreq ? 1.0f : (float)totalTermFreq / (float)docFreq;
        return 128.0f + expOccurrencesInMatchingDoc * 7.0f;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (this.term.field().equals(field)) {
            buffer.append(this.term.text());
        } else {
            buffer.append(this.term.toString());
        }
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.term.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.term.equals(((SpanTermQuery)other).term);
    }

    public class SpanTermWeight
    extends SpanWeight {
        final TermContext termContext;

        public SpanTermWeight(TermContext termContext, IndexSearcher searcher, Map<Term, TermContext> terms, float boost) throws IOException {
            super(SpanTermQuery.this, searcher, terms, boost);
            this.termContext = termContext;
            assert (termContext != null) : "TermContext must not be null";
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            terms.add(SpanTermQuery.this.term);
        }

        @Override
        public void extractTermContexts(Map<Term, TermContext> contexts) {
            contexts.put(SpanTermQuery.this.term, this.termContext);
        }

        @Override
        public Spans getSpans(LeafReaderContext context2, SpanWeight.Postings requiredPostings) throws IOException {
            assert (this.termContext.wasBuiltFor(ReaderUtil.getTopLevelContext(context2))) : "The top-reader used to create Weight is not the same as the current reader's top-reader (" + ReaderUtil.getTopLevelContext(context2);
            TermState state = this.termContext.get(context2.ord);
            if (state == null) {
                assert (context2.reader().docFreq(SpanTermQuery.this.term) == 0) : "no termstate found but term exists in reader term=" + SpanTermQuery.this.term;
                return null;
            }
            Terms terms = context2.reader().terms(SpanTermQuery.this.term.field());
            if (terms == null) {
                return null;
            }
            if (!terms.hasPositions()) {
                throw new IllegalStateException("field \"" + SpanTermQuery.this.term.field() + "\" was indexed without position data; cannot run SpanTermQuery (term=" + SpanTermQuery.this.term.text() + ")");
            }
            TermsEnum termsEnum = terms.iterator();
            termsEnum.seekExact(SpanTermQuery.this.term.bytes(), state);
            PostingsEnum postings = termsEnum.postings(null, requiredPostings.getRequiredPostings());
            float positionsCost = SpanTermQuery.termPositionsCost(termsEnum) * 4.0f;
            return new TermSpans(this.getSimScorer(context2), postings, SpanTermQuery.this.term, positionsCost);
        }
    }
}

