/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.storage.ocfl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import edu.wisc.library.ocfl.api.MutableOcflRepository;
import java.nio.file.Path;
import java.util.Objects;
import java.util.UUID;
import org.fcrepo.storage.ocfl.CommitType;
import org.fcrepo.storage.ocfl.DefaultOcflObjectSession;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.ResourceHeaders;
import org.fcrepo.storage.ocfl.cache.Cache;
import org.fcrepo.storage.ocfl.validation.DefaultHeadersValidator;
import org.fcrepo.storage.ocfl.validation.HeadersValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOcflObjectSessionFactory
implements OcflObjectSessionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOcflObjectSessionFactory.class);
    private final MutableOcflRepository ocflRepo;
    private final Path stagingRoot;
    private final ObjectReader headerReader;
    private final ObjectWriter headerWriter;
    private final Cache<String, ResourceHeaders> headersCache;
    private final Cache<String, String> rootIdCache;
    private CommitType defaultCommitType;
    private final String defaultVersionMessage;
    private final String defaultVersionUserName;
    private final String defaultVersionUserAddress;
    private HeadersValidator headersValidator;
    private boolean useUnsafeWrite = false;
    private boolean closed = false;

    public DefaultOcflObjectSessionFactory(MutableOcflRepository ocflRepo, Path stagingRoot, ObjectMapper objectMapper, Cache<String, ResourceHeaders> headersCache, Cache<String, String> rootIdCache, CommitType defaultCommitType, String defaultVersionMessage, String defaultVersionUserName, String defaultVersionUserAddress) {
        this.ocflRepo = Objects.requireNonNull(ocflRepo, "ocflRepo cannot be null");
        this.stagingRoot = Objects.requireNonNull(stagingRoot, "stagingRoot cannot be null");
        this.headerReader = Objects.requireNonNull(objectMapper, "objectMapper cannot be null").readerFor(ResourceHeaders.class);
        this.headerWriter = objectMapper.writerFor(ResourceHeaders.class);
        this.headersCache = headersCache;
        this.rootIdCache = rootIdCache;
        this.defaultCommitType = Objects.requireNonNull(defaultCommitType, "defaultCommitType cannot be null");
        this.defaultVersionMessage = defaultVersionMessage;
        this.defaultVersionUserName = defaultVersionUserName;
        this.defaultVersionUserAddress = defaultVersionUserAddress;
        this.headersValidator = new DefaultHeadersValidator();
    }

    @Override
    public OcflObjectSession newSession(String ocflObjectId) {
        this.enforceOpen();
        String sessionId = UUID.randomUUID().toString();
        DefaultOcflObjectSession session = new DefaultOcflObjectSession(sessionId, this.ocflRepo, ocflObjectId, this.stagingRoot.resolve(sessionId), this.headerReader, this.headerWriter, this.defaultCommitType, this.headersCache, this.rootIdCache, this.headersValidator, this.useUnsafeWrite);
        session.versionAuthor(this.defaultVersionUserName, this.defaultVersionUserAddress);
        session.versionMessage(this.defaultVersionMessage);
        return session;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.ocflRepo.close();
        }
    }

    @Override
    public void useUnsafeWrite(boolean useUnsafeWrite) {
        this.useUnsafeWrite = useUnsafeWrite;
    }

    private void enforceOpen() {
        if (this.closed) {
            throw new IllegalStateException("The session factory is closed!");
        }
    }

    public void setDefaultCommitType(CommitType defaultCommitType) {
        this.defaultCommitType = Objects.requireNonNull(defaultCommitType, "defaultCommitType cannot be null");
    }

    public void setHeadersValidator(HeadersValidator headersValidator) {
        this.headersValidator = headersValidator;
    }
}

