/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.log;

import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.springframework.lang.Nullable;

public abstract class LogFormatUtils {
    public static String formatValue(@Nullable Object value, boolean limitLength) {
        String str2;
        if (value == null) {
            return "";
        }
        if (value instanceof CharSequence) {
            str2 = "\"" + value + "\"";
        } else {
            try {
                str2 = value.toString();
            }
            catch (Throwable ex) {
                str2 = ex.toString();
            }
        }
        return limitLength && str2.length() > 100 ? str2.substring(0, 100) + " (truncated)..." : str2;
    }

    public static void traceDebug(Log logger, Function<Boolean, String> messageFactory) {
        if (logger.isDebugEnabled()) {
            boolean traceEnabled = logger.isTraceEnabled();
            String logMessage = messageFactory.apply(traceEnabled);
            if (traceEnabled) {
                logger.trace(logMessage);
            } else {
                logger.debug(logMessage);
            }
        }
    }
}

