/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.handlers.ocfl;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    private static final Counter byteCounter = Metrics.counter((String)"fcrepo.storage.bytes", (String[])new String[]{"operation", "bytesProcessed"});
    private final InputStream inner;

    public CountingInputStream(InputStream inner) {
        this.inner = inner;
    }

    @Override
    public int read() throws IOException {
        int result = this.inner.read();
        if (result != -1) {
            byteCounter.increment((double)result);
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.inner.read(b, off, len);
        if (result != -1) {
            byteCounter.increment((double)result);
        }
        return result;
    }
}

