/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.handlers.ocfl;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Stream;
import org.fcrepo.migration.handlers.ocfl.CountingInputStream;
import org.fcrepo.storage.ocfl.CommitType;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.fcrepo.storage.ocfl.OcflVersionInfo;
import org.fcrepo.storage.ocfl.ResourceContent;
import org.fcrepo.storage.ocfl.ResourceHeaders;

public class OcflObjectSessionWrapper
implements OcflObjectSession {
    private final OcflObjectSession inner;
    private static final String METRIC_NAME = "fcrepo.storage.ocfl.object";
    private static final String OPERATION = "operation";
    private static final Timer writeTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "write"});
    private static final Timer writeHeadersTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "writeHeaders"});
    private static final Timer deleteContentTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "deleteContent"});
    private static final Timer deleteResourceTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "deleteResource"});
    private static final Timer readHeadersTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "readHeaders"});
    private static final Timer readContentTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "readContent"});
    private static final Timer listVersionsTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "listVersions"});
    private static final Timer containsResourceTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "containsResource"});
    private static final Timer commitTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "commit"});

    public OcflObjectSessionWrapper(OcflObjectSession inner) {
        this.inner = inner;
    }

    public String sessionId() {
        return this.inner.sessionId();
    }

    public String ocflObjectId() {
        return this.inner.ocflObjectId();
    }

    public ResourceHeaders writeResource(ResourceHeaders headers, InputStream content) {
        CountingInputStream countingStream = content != null ? new CountingInputStream(content) : null;
        return (ResourceHeaders)writeTimer.record(() -> this.inner.writeResource(headers, (InputStream)countingStream));
    }

    public void writeHeaders(ResourceHeaders headers) {
        writeHeadersTimer.record(() -> this.inner.writeHeaders(headers));
    }

    public void deleteContentFile(ResourceHeaders headers) {
        deleteContentTimer.record(() -> this.inner.deleteContentFile(headers));
    }

    public void deleteResource(String resourceId) {
        deleteResourceTimer.record(() -> this.inner.deleteResource(resourceId));
    }

    public boolean containsResource(String resourceId) {
        return (Boolean)containsResourceTimer.record(() -> this.inner.containsResource(resourceId));
    }

    public ResourceHeaders readHeaders(String resourceId) {
        return (ResourceHeaders)readHeadersTimer.record(() -> this.inner.readHeaders(resourceId));
    }

    public ResourceHeaders readHeaders(String resourceId, String versionNumber) {
        return (ResourceHeaders)readHeadersTimer.record(() -> this.inner.readHeaders(resourceId, versionNumber));
    }

    public ResourceContent readContent(String resourceId) {
        return (ResourceContent)readContentTimer.record(() -> this.inner.readContent(resourceId));
    }

    public ResourceContent readContent(String resourceId, String versionNumber) {
        return (ResourceContent)readContentTimer.record(() -> this.inner.readContent(resourceId, versionNumber));
    }

    public List<OcflVersionInfo> listVersions(String resourceId) {
        return (List)listVersionsTimer.record(() -> this.inner.listVersions(resourceId));
    }

    public Stream<ResourceHeaders> streamResourceHeaders() {
        return this.inner.streamResourceHeaders();
    }

    public void versionCreationTimestamp(OffsetDateTime timestamp) {
        this.inner.versionCreationTimestamp(timestamp);
    }

    public void versionAuthor(String name, String address) {
        this.inner.versionAuthor(name, address);
    }

    public void versionMessage(String message) {
        this.inner.versionMessage(message);
    }

    public void commitType(CommitType commitType) {
        this.inner.commitType(commitType);
    }

    public void commit() {
        commitTimer.record(() -> ((OcflObjectSession)this.inner).commit());
    }

    public void abort() {
        this.inner.abort();
    }

    public void rollback() {
        this.inner.rollback();
    }

    public boolean isOpen() {
        return this.inner.isOpen();
    }

    public void close() {
        this.inner.close();
    }
}

