/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.api.exception;

import edu.wisc.library.ocfl.api.exception.OcflJavaException;
import edu.wisc.library.ocfl.api.exception.OcflNoSuchFileException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;

public class OcflIOException
extends OcflJavaException {
    private IOException cause;
    private boolean hasMessage = false;

    public static OcflIOException from(IOException e2) {
        if (e2 instanceof NoSuchFileException || e2 instanceof FileNotFoundException) {
            return new OcflNoSuchFileException(e2);
        }
        return new OcflIOException(e2);
    }

    public OcflIOException(IOException cause) {
        super(cause);
        this.cause = cause;
    }

    public OcflIOException(String message, IOException cause) {
        super(message, cause);
        this.cause = cause;
        this.hasMessage = true;
    }

    @Override
    public String getMessage() {
        if (this.hasMessage) {
            return super.getMessage();
        }
        return this.cause.getClass().getSimpleName() + ": " + this.cause.getMessage();
    }
}

