/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.extension;

import edu.wisc.library.ocfl.api.exception.OcflExtensionException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.extension.OcflExtensionRegistry;
import edu.wisc.library.ocfl.core.extension.UnsupportedExtensionBehavior;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionSupportEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionSupportEvaluator.class);
    private static final Set<String> BUILTIN_EXTS = Set.of("0005-mutable-head", "0001-digest-algorithms");
    private final UnsupportedExtensionBehavior behavior;
    private final Set<String> ignore;

    public ExtensionSupportEvaluator() {
        this(UnsupportedExtensionBehavior.FAIL, Collections.emptySet());
    }

    public ExtensionSupportEvaluator(UnsupportedExtensionBehavior behavior, Set<String> ignore) {
        this.behavior = Enforce.notNull(behavior, "behavior cannot be null");
        this.ignore = Enforce.notNull(ignore, "ignore cannot be null");
    }

    public boolean checkSupport(String extensionName) {
        if (!OcflExtensionRegistry.isSupported(extensionName) && !BUILTIN_EXTS.contains(extensionName)) {
            boolean ignored = this.ignore.contains(extensionName);
            String message = String.format("Extension %s is not currently supported by ocfl-java.", extensionName);
            if (this.behavior == UnsupportedExtensionBehavior.FAIL) {
                if (!ignored) {
                    throw new OcflExtensionException(message);
                }
                LOG.warn(message);
                return false;
            }
            if (!ignored) {
                LOG.warn(message);
                return false;
            }
        }
        return true;
    }
}

