/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.extension.storage.layout;

import edu.wisc.library.ocfl.api.exception.OcflExtensionException;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.extension.storage.layout.OcflStorageLayoutExtension;
import edu.wisc.library.ocfl.core.extension.storage.layout.config.FlatLayoutConfig;
import java.nio.file.FileSystems;

public class FlatLayoutExtension
implements OcflStorageLayoutExtension {
    public static final String EXTENSION_NAME = "0002-flat-direct-storage-layout";
    private final char pathSeparator = FileSystems.getDefault().getSeparator().charAt(0);

    @Override
    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    @Override
    public String getDescription() {
        return "OCFL object identifiers are mapped directly to directory names that are direct children of the OCFL storage root.";
    }

    @Override
    public synchronized void init(OcflExtensionConfig config) {
    }

    @Override
    public Class<? extends OcflExtensionConfig> getExtensionConfigClass() {
        return FlatLayoutConfig.class;
    }

    @Override
    public String mapObjectId(String objectId) {
        if (objectId.indexOf(this.pathSeparator) != -1) {
            throw new OcflExtensionException(String.format("The object id <%s> is incompatible with layout extension %s because it contains the path separator character.", objectId, EXTENSION_NAME));
        }
        if ("extensions".equals(objectId)) {
            throw new OcflExtensionException(String.format("The object id <%s> is incompatible with layout extension %s because it conflicts with the extensions directory.", objectId, EXTENSION_NAME));
        }
        return objectId;
    }
}

