/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.util;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.UnicodeEscaper;
import java.util.HashSet;
import java.util.Set;

@Beta
@GwtCompatible
public final class PercentEscaper
extends UnicodeEscaper {
    private static final char[] PLUS_SIGN = new char[]{'+'};
    private static final char[] UPPER_HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private static final char[] LOWER_HEX_DIGITS = "0123456789abcdef".toCharArray();
    private final Behavior behavior;
    private final boolean plusForSpace;
    private final boolean[] octets;
    private final char[] hexDigits;

    public static Builder builder() {
        return new Builder(false);
    }

    public static Builder builderWithSafeAlphaNumeric() {
        return new Builder(true);
    }

    private PercentEscaper(Behavior behavior, Set<Character> charSet, boolean plusForSpace, boolean useUppercase) {
        Preconditions.checkNotNull(charSet);
        this.behavior = Preconditions.checkNotNull(behavior);
        this.plusForSpace = plusForSpace;
        HashSet<Character> charSetCopy = new HashSet<Character>(charSet);
        if (behavior == Behavior.ENCODE_SET) {
            if (plusForSpace) {
                charSetCopy.add(Character.valueOf(' '));
            }
            charSetCopy.add(Character.valueOf('%'));
        } else {
            if (plusForSpace) {
                charSetCopy.remove(Character.valueOf(' '));
            }
            charSetCopy.remove(Character.valueOf('%'));
        }
        this.octets = PercentEscaper.createOctets(charSetCopy);
        this.hexDigits = useUppercase ? UPPER_HEX_DIGITS : LOWER_HEX_DIGITS;
    }

    private static boolean[] createOctets(Set<Character> charSet) {
        int maxChar = -1;
        for (char c : charSet) {
            maxChar = Math.max(c, maxChar);
        }
        boolean[] octets = new boolean[maxChar + 1];
        for (char c : charSet) {
            octets[c] = true;
        }
        return octets;
    }

    @Override
    protected int nextEscapeIndex(CharSequence csq, int index, int end) {
        char c;
        Preconditions.checkNotNull(csq);
        while (index < end && !this.shouldEscapeChar(c = csq.charAt(index))) {
            ++index;
        }
        return index;
    }

    @Override
    public String escape(String s2) {
        Preconditions.checkNotNull(s2);
        int slen = s2.length();
        for (int index = 0; index < slen; ++index) {
            char c = s2.charAt(index);
            if (!this.shouldEscapeChar(c)) continue;
            return this.escapeSlow(s2, index);
        }
        return s2;
    }

    private boolean shouldEscapeChar(char c) {
        return this.behavior == Behavior.ENCODE_NOT_IN_SET && (c >= this.octets.length || !this.octets[c]) || this.behavior == Behavior.ENCODE_SET && c < this.octets.length && this.octets[c];
    }

    @Override
    protected char[] escape(int cp) {
        if (!this.shouldEscapeChar((char)cp)) {
            return null;
        }
        if (cp == 32 && this.plusForSpace) {
            return PLUS_SIGN;
        }
        if (cp <= 127) {
            char[] dest = new char[3];
            dest[0] = 37;
            dest[2] = this.hexDigits[cp & 0xF];
            dest[1] = this.hexDigits[cp >>> 4];
            return dest;
        }
        if (cp <= 2047) {
            char[] dest = new char[6];
            dest[0] = 37;
            dest[3] = 37;
            dest[5] = this.hexDigits[cp & 0xF];
            dest[4] = this.hexDigits[8 | (cp >>>= 4) & 3];
            dest[2] = this.hexDigits[(cp >>>= 2) & 0xF];
            dest[1] = this.hexDigits[0xC | (cp >>>= 4)];
            return dest;
        }
        if (cp <= 65535) {
            char[] dest = new char[9];
            dest[0] = 37;
            dest[1] = 69;
            dest[3] = 37;
            dest[6] = 37;
            dest[8] = this.hexDigits[cp & 0xF];
            dest[7] = this.hexDigits[8 | (cp >>>= 4) & 3];
            dest[5] = this.hexDigits[(cp >>>= 2) & 0xF];
            dest[4] = this.hexDigits[8 | (cp >>>= 4) & 3];
            dest[2] = this.hexDigits[cp >>>= 2];
            return dest;
        }
        if (cp <= 0x10FFFF) {
            char[] dest = new char[12];
            dest[0] = 37;
            dest[1] = 70;
            dest[3] = 37;
            dest[6] = 37;
            dest[9] = 37;
            dest[11] = this.hexDigits[cp & 0xF];
            dest[10] = this.hexDigits[8 | (cp >>>= 4) & 3];
            dest[8] = this.hexDigits[(cp >>>= 2) & 0xF];
            dest[7] = this.hexDigits[8 | (cp >>>= 4) & 3];
            dest[5] = this.hexDigits[(cp >>>= 2) & 0xF];
            dest[4] = this.hexDigits[8 | (cp >>>= 4) & 3];
            dest[2] = this.hexDigits[(cp >>>= 2) & 7];
            return dest;
        }
        throw new IllegalArgumentException("Invalid unicode character value " + cp);
    }

    private static enum Behavior {
        ENCODE_SET,
        ENCODE_NOT_IN_SET;

    }

    public static class Builder {
        private static final String ALPHA_NUMERIC_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        private boolean plusForSpace = false;
        private boolean useUppercase = false;
        private Behavior behavior = null;
        private final Set<Character> charSet = new HashSet<Character>();

        private Builder(boolean safeAlphaNumeric) {
            if (safeAlphaNumeric) {
                this.behavior = Behavior.ENCODE_NOT_IN_SET;
                Builder.addToSet(ALPHA_NUMERIC_CHARS, this.charSet);
            }
        }

        private static void addToSet(String chars, Set<Character> charSet) {
            chars.chars().forEach(c -> charSet.add(Character.valueOf((char)c)));
        }

        private static void addRangeToSet(char start, char end, Set<Character> charSet) {
            Preconditions.checkArgument(start < end, "The start char must come before the end char.");
            for (char c = start; c <= end; c = (char)(c + '\u0001')) {
                charSet.add(Character.valueOf(c));
            }
        }

        public Builder addSafeCharRange(char start, char end) {
            if (this.behavior == Behavior.ENCODE_SET) {
                throw new IllegalArgumentException("Cannot add safe characters because the escaper is already configured with unsafe characters.");
            }
            this.behavior = Behavior.ENCODE_NOT_IN_SET;
            Builder.addRangeToSet(start, end, this.charSet);
            return this;
        }

        public Builder addSafeChars(String safeChars) {
            if (this.behavior == Behavior.ENCODE_SET) {
                throw new IllegalArgumentException("Cannot add safe characters because the escaper is already configured with unsafe characters.");
            }
            this.behavior = Behavior.ENCODE_NOT_IN_SET;
            Builder.addToSet(safeChars, this.charSet);
            return this;
        }

        public Builder addUnsafeCharRange(char start, char end) {
            if (this.behavior == Behavior.ENCODE_NOT_IN_SET) {
                throw new IllegalArgumentException("Cannot add unsafe characters because the escaper is already configured with safe characters.");
            }
            this.behavior = Behavior.ENCODE_SET;
            Builder.addRangeToSet(start, end, this.charSet);
            return this;
        }

        public Builder addUnsafeChars(String unsafeChars) {
            if (this.behavior == Behavior.ENCODE_NOT_IN_SET) {
                throw new IllegalArgumentException("Cannot add unsafe characters because the escaper is already configured with safe characters.");
            }
            this.behavior = Behavior.ENCODE_SET;
            Builder.addToSet(unsafeChars, this.charSet);
            return this;
        }

        public Builder plusForSpace(boolean plusForSpace) {
            this.plusForSpace = plusForSpace;
            return this;
        }

        public Builder useUppercase(boolean useUppercase) {
            this.useUppercase = useUppercase;
            return this;
        }

        public PercentEscaper build() {
            return new PercentEscaper(this.behavior, this.charSet, this.plusForSpace, this.useUppercase);
        }
    }
}

