/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.jodah.failsafe.AbstractExecution;
import net.jodah.failsafe.ExecutionResult;
import net.jodah.failsafe.FailsafeFuture;
import net.jodah.failsafe.Fallback;
import net.jodah.failsafe.PolicyExecutor;
import net.jodah.failsafe.internal.EventListener;
import net.jodah.failsafe.util.concurrent.Scheduler;

class FallbackExecutor<R>
extends PolicyExecutor<R, Fallback<R>> {
    private final EventListener failedAttemptListener;

    FallbackExecutor(Fallback<R> fallback, AbstractExecution<R> execution, EventListener failedAttemptListener) {
        super(fallback, execution);
        this.failedAttemptListener = failedAttemptListener;
    }

    @Override
    protected Supplier<ExecutionResult> supply(Supplier<ExecutionResult> supplier, Scheduler scheduler) {
        return () -> {
            ExecutionResult result = (ExecutionResult)supplier.get();
            if (this.executionCancelled()) {
                return result;
            }
            if (this.isFailure(result)) {
                if (this.failedAttemptListener != null) {
                    this.failedAttemptListener.handle(result, this.execution);
                }
                try {
                    result = this.policy == Fallback.VOID ? result.withNonResult() : result.withResult(((Fallback)this.policy).apply(result.getResult(), result.getFailure(), this.execution.copy()));
                }
                catch (Throwable t2) {
                    result = ExecutionResult.failure(t2);
                }
            }
            return this.postExecute(result);
        };
    }

    @Override
    protected Supplier<CompletableFuture<ExecutionResult>> supplyAsync(Supplier<CompletableFuture<ExecutionResult>> supplier, Scheduler scheduler, FailsafeFuture<R> future) {
        return () -> ((CompletableFuture)supplier.get()).thenCompose(result -> {
            if (result == null || future.isDone()) {
                return ExecutionResult.NULL_FUTURE;
            }
            if (this.executionCancelled()) {
                return CompletableFuture.completedFuture(result);
            }
            if (!this.isFailure((ExecutionResult)result)) {
                return this.postExecuteAsync((ExecutionResult)result, scheduler, future);
            }
            if (this.failedAttemptListener != null) {
                this.failedAttemptListener.handle((ExecutionResult)result, this.execution);
            }
            CompletableFuture promise = new CompletableFuture();
            Callable<Object> callable = () -> {
                try {
                    CompletableFuture<Object> fallback = ((Fallback)this.policy).applyStage(result.getResult(), result.getFailure(), this.execution.copy());
                    fallback.whenComplete((innerResult, failure) -> {
                        if (failure instanceof CompletionException) {
                            failure = failure.getCause();
                        }
                        ExecutionResult r = failure == null ? result.withResult(innerResult) : ExecutionResult.failure(failure);
                        promise.complete(r);
                    });
                }
                catch (Throwable t2) {
                    promise.complete(ExecutionResult.failure(t2));
                }
                return null;
            };
            try {
                if (!((Fallback)this.policy).isAsync()) {
                    callable.call();
                } else {
                    ScheduledFuture<?> scheduledFallback = scheduler.schedule(callable, 0L, TimeUnit.NANOSECONDS);
                    future.injectCancelFn((mayInterrupt, promiseResult) -> {
                        scheduledFallback.cancel((boolean)mayInterrupt);
                        if (this.executionCancelled()) {
                            promise.complete(promiseResult);
                        }
                    });
                }
            }
            catch (Throwable t2) {
                promise.completeExceptionally(t2);
            }
            return promise.thenCompose(ss -> this.postExecuteAsync((ExecutionResult)ss, scheduler, future));
        });
    }
}

