/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem;

import org.apache.jena.graph.GraphEvents;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.TripleStore;
import org.apache.jena.mem.GraphMemBase;
import org.apache.jena.mem.GraphTripleStoreMem;
import org.apache.jena.util.iterator.ExtendedIterator;

public class GraphMem
extends GraphMemBase {
    @Override
    protected TripleStore createTripleStore() {
        return new GraphTripleStoreMem(this);
    }

    @Override
    protected void destroy() {
        this.store.close();
    }

    @Override
    public void performAdd(Triple t2) {
        this.store.add(t2);
    }

    @Override
    public void performDelete(Triple t2) {
        this.store.delete(t2);
    }

    @Override
    public int graphBaseSize() {
        return this.store.size();
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(Triple m4) {
        return this.store.find(m4);
    }

    @Override
    public boolean graphBaseContains(Triple t2) {
        return t2.isConcrete() ? this.store.contains(t2) : super.graphBaseContains(t2);
    }

    @Override
    public void clear() {
        this.clearStore();
        this.getEventManager().notifyEvent(this, GraphEvents.removeAll);
    }

    public void clearStore() {
        this.store.clear();
    }
}

