/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmloutput.impl;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.jena.JenaRuntime;
import org.apache.jena.ext.xerces.util.XMLChar;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NsIterator;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.RDFDefaultErrorHandler;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.rdfxml.xmloutput.RDFXMLWriterI;
import org.apache.jena.rdfxml.xmloutput.impl.Relation;
import org.apache.jena.rdfxml.xmloutput.impl.SimpleLogger;
import org.apache.jena.shared.BadBooleanException;
import org.apache.jena.shared.BadURIException;
import org.apache.jena.shared.BrokenException;
import org.apache.jena.shared.InvalidPropertyURIException;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.CharEncoding;
import org.apache.jena.util.FileUtils;
import org.apache.jena.vocabulary.DC;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.RDFSyntax;
import org.apache.jena.vocabulary.RSS;
import org.apache.jena.vocabulary.VCARD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseXMLWriter
implements RDFXMLWriterI {
    private static final String newline = JenaRuntime.getSystemProperty("line.separator");
    private static final String DEFAULT_NS_ENTITY_NAME = "this";
    private static final String DEFAULT_NS_ENTITY_NAME_ALT = "here";
    private String defaultNSEntityName = "UNSET";
    private static Logger xlogger = LoggerFactory.getLogger(BaseXMLWriter.class);
    protected static SimpleLogger logger = new SimpleLogger(){

        @Override
        public void warn(String s2) {
            xlogger.warn(s2);
        }

        @Override
        public void warn(String s2, Exception e2) {
            xlogger.warn(s2, e2);
        }
    };
    private static Set<String> badRDF = new HashSet<String>();
    private int jenaPrefixCount;
    static String RDFNS = RDF.getURI();
    private static Pattern jenaNamespace = Pattern.compile("j\\.([1-9][0-9]*|cook\\.up)");
    String xmlBase = null;
    private IRI baseURI;
    boolean longId = false;
    private boolean demandGoodURIs = true;
    int tabSize = 2;
    int width = 60;
    HashMap<AnonId, String> anonMap = new HashMap();
    int anonCount = 0;
    private static RDFDefaultErrorHandler defaultErrorHandler;
    RDFErrorHandler errorHandler = defaultErrorHandler;
    Boolean showXmlDeclaration = null;
    protected Boolean showDoctypeDeclaration = Boolean.FALSE;
    private boolean writingAllModelPrefixNamespaces = true;
    private Relation<String> nameSpaces = new Relation();
    private Map<String, String> ns;
    private PrefixMapping modelPrefixMapping;
    private Set<String> namespacesNeeded;
    private static final int FAST = 1;
    private static final int START = 2;
    private static final int END = 3;
    private static final int ATTR = 4;
    private static final int FASTATTR = 5;
    static IRIFactory factory;
    protected static final Pattern predefinedEntityNames;
    private String attributeQuoteChar = "\"";
    private static final char ESCAPE = 'X';
    static final char[] hexchar;
    private Resource[] blockedRules = new Resource[]{RDFSyntax.propertyAttr};
    private int relativeFlags = 29;

    public BaseXMLWriter() {
        this.setupMaps();
    }

    public static SimpleLogger setLogger(SimpleLogger lg) {
        SimpleLogger old = logger;
        logger = lg;
        return old;
    }

    protected abstract void unblockAll();

    protected abstract void blockRule(Resource var1);

    protected abstract void writeBody(Model var1, PrintWriter var2, String var3, boolean var4);

    String anonId(Resource r) {
        return this.longId ? this.longAnonId(r) : this.shortAnonId(r);
    }

    private String shortAnonId(Resource r) {
        Object result = this.anonMap.get(r.getId());
        if (result == null) {
            result = "A" + Integer.toString(this.anonCount++);
            this.anonMap.put(r.getId(), (String)result);
        }
        return result;
    }

    private String longAnonId(Resource r) {
        String rid = r.getId().toString();
        return XMLChar.isValidNCName(rid) ? rid : BaseXMLWriter.escapedId(rid);
    }

    void addNameSpace(String uri) {
        this.namespacesNeeded.add(uri);
    }

    boolean isDefaultNamespace(String uri) {
        return "".equals(this.ns.get(uri));
    }

    private void addNameSpaces(Model model) {
        NsIterator nsIter = model.listNameSpaces();
        while (nsIter.hasNext()) {
            this.addNameSpace(nsIter.nextNs());
        }
    }

    private void primeNamespace(Model model) {
        Map<String, String> m4 = model.getNsPrefixMap();
        for (Map.Entry<String, String> e2 : m4.entrySet()) {
            String value = e2.getValue();
            String already = this.getPrefixFor(value);
            if (already != null) continue;
            this.setNsPrefix(model.getNsURIPrefix(value), value);
            if (!this.writingAllModelPrefixNamespaces) continue;
            this.addNameSpace(value);
        }
        if (BaseXMLWriter.usesPrefix(model, "")) {
            Object entityForEmptyPrefix = DEFAULT_NS_ENTITY_NAME;
            if (BaseXMLWriter.usesPrefix(model, (String)entityForEmptyPrefix)) {
                entityForEmptyPrefix = DEFAULT_NS_ENTITY_NAME_ALT;
            }
            int i = 0;
            while (BaseXMLWriter.usesPrefix(model, (String)entityForEmptyPrefix)) {
                entityForEmptyPrefix = "here." + i;
                ++i;
            }
            this.defaultNSEntityName = entityForEmptyPrefix;
        }
    }

    void setupMaps() {
        this.nameSpaces.set11(RDF.getURI(), "rdf");
        this.nameSpaces.set11(RDFS.getURI(), "rdfs");
        this.nameSpaces.set11(DC.getURI(), "dc");
        this.nameSpaces.set11(RSS.getURI(), "rss");
        this.nameSpaces.set11("http://www.daml.org/2001/03/daml+oil.daml#", "daml");
        this.nameSpaces.set11(VCARD.getURI(), "vcard");
        this.nameSpaces.set11("http://www.w3.org/2002/07/owl#", "owl");
    }

    void workOutNamespaces() {
        if (this.ns == null) {
            this.ns = new HashMap<String, String>();
            HashSet<String> prefixesUsed = new HashSet<String>();
            this.setFromWriterSystemProperties(this.ns, prefixesUsed);
            this.setFromGivenNamespaces(this.ns, prefixesUsed);
        }
    }

    private void setFromWriterSystemProperties(Map<String, String> ns, Set<String> prefixesUsed) {
        for (String uri : this.namespacesNeeded) {
            String val = JenaRuntime.getSystemProperty("org.apache.jena.nsprefix." + uri);
            if (val == null || !this.checkLegalPrefix(val) || prefixesUsed.contains(val)) continue;
            ns.put(uri, val);
            prefixesUsed.add(val);
        }
    }

    private void setFromGivenNamespaces(Map<String, String> ns, Set<String> prefixesUsed) {
        for (String uri : this.namespacesNeeded) {
            if (ns.containsKey(uri)) continue;
            Object val = null;
            Set<String> s2 = this.nameSpaces.forward(uri);
            if (s2 != null) {
                Iterator<String> it2 = s2.iterator();
                if (it2.hasNext()) {
                    val = it2.next();
                }
                if (prefixesUsed.contains(val)) {
                    val = null;
                }
            }
            if (val == null) {
                while (prefixesUsed.contains(val = "j." + this.jenaPrefixCount++)) {
                }
            }
            ns.put(uri, (String)val);
            prefixesUsed.add((String)val);
        }
    }

    public final synchronized void setNsPrefix(String prefix, String ns) {
        if (this.checkLegalPrefix(prefix)) {
            this.nameSpaces.set11(ns, prefix);
        }
    }

    public final String getPrefixFor(String uri) {
        if ("http://www.w3.org/XML/1998/namespace".equals(uri)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(uri)) {
            return "xmlns";
        }
        Set<String> s2 = this.nameSpaces.backward(uri);
        if (s2 != null && s2.size() == 1) {
            return s2.iterator().next();
        }
        return null;
    }

    String xmlnsDecl() {
        this.workOutNamespaces();
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> ent : this.ns.entrySet()) {
            String prefix = ent.getValue();
            String uri = ent.getKey();
            result.append(newline).append("    xmlns");
            if (prefix.length() > 0) {
                result.append(':').append(prefix);
            }
            result.append('=').append(this.substitutedAttribute(this.checkURI(uri)));
        }
        return result.toString();
    }

    String rdfEl(String local) {
        return this.tag(RDFNS, local, 1, true);
    }

    String startElementTag(String uri, String local) {
        return this.tag(uri, local, 2, false);
    }

    protected String startElementTag(String uriref) {
        return this.splitTag(uriref, 2);
    }

    String attributeTag(String uriref) {
        return this.splitTag(uriref, 4);
    }

    String attributeTag(String uri, String local) {
        return this.tag(uri, local, 4, false);
    }

    String rdfAt(String local) {
        return this.tag(RDFNS, local, 5, true);
    }

    String endElementTag(String uri, String local) {
        return this.tag(uri, local, 3, false);
    }

    protected String endElementTag(String uriref) {
        return this.splitTag(uriref, 3);
    }

    String splitTag(String uriref, int type) {
        int split = Util.splitNamespaceXML(uriref);
        if (split == uriref.length()) {
            throw new InvalidPropertyURIException(uriref);
        }
        return this.tag(uriref.substring(0, split), uriref.substring(split), type, true);
    }

    String tag(String namespace2, String local, int type, boolean localIsQname) {
        String prefix = this.ns.get(namespace2);
        if (type != 1 && type != 5) {
            if (!localIsQname && !XMLChar.isValidNCName(local)) {
                return this.splitTag(namespace2 + local, type);
            }
            if (namespace2.equals(RDFNS) && badRDF.contains(local)) {
                logger.warn("The URI rdf:" + local + " cannot be serialized in RDF/XML.");
                throw new InvalidPropertyURIException("rdf:" + local);
            }
        }
        boolean cookUp = false;
        if (prefix == null) {
            this.checkURI(namespace2);
            logger.warn("Internal error: unexpected QName URI: <" + namespace2 + ">.  Fixing up with j.cook.up code.", new BrokenException("unexpected QName URI " + namespace2));
            cookUp = true;
        } else if (prefix.length() == 0) {
            if (type == 4 || type == 5) {
                cookUp = true;
            } else {
                return local;
            }
        }
        if (cookUp) {
            return this.cookUpAttribution(type, namespace2, local);
        }
        return prefix + ":" + local;
    }

    private String cookUpAttribution(int type, String namespace2, String local) {
        String prefix = "j.cook.up";
        switch (type) {
            case 4: 
            case 5: {
                return "xmlns:" + prefix + "=" + this.substitutedAttribute(namespace2) + " " + prefix + ":" + local;
            }
            case 2: {
                return prefix + ":" + local + " xmlns:" + prefix + "=" + this.substitutedAttribute(namespace2);
            }
            default: {
                return prefix + ":" + local;
            }
            case 1: 
        }
        throw new BrokenException("cookup reached final FAST");
    }

    @Override
    public final void write(Model model, OutputStream out, String base) {
        this.write(model, FileUtils.asUTF8(out), base);
    }

    @Override
    public synchronized void write(Model model, Writer out, String base) {
        PrintWriter pw;
        this.setupNamespaces(model);
        PrintWriter printWriter = pw = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
        if (!Boolean.FALSE.equals(this.showXmlDeclaration)) {
            this.writeXMLDeclaration(out, pw);
        }
        this.writeXMLBody(model, pw, base);
        pw.flush();
    }

    private void setupNamespaces(Model model) {
        this.namespacesNeeded = new HashSet<String>();
        this.ns = null;
        this.modelPrefixMapping = model;
        this.primeNamespace(model);
        this.addNameSpace(RDF.getURI());
        this.addNameSpaces(model);
        this.jenaPrefixCount = 0;
    }

    private void writeXMLBody(Model model, PrintWriter pw, String base) {
        if (this.showDoctypeDeclaration.booleanValue()) {
            this.generateDoctypeDeclaration(model, pw);
        }
        if (this.xmlBase == null) {
            this.baseURI = base == null || base.length() == 0 ? null : factory.create(base);
            this.writeBody(model, pw, base, false);
        } else {
            this.baseURI = this.xmlBase.length() == 0 ? null : factory.create(this.xmlBase);
            this.writeBody(model, pw, this.xmlBase, true);
        }
    }

    public boolean isPredefinedEntityName(String name) {
        return predefinedEntityNames.matcher(name).matches();
    }

    protected String attributeQuoted(String s2) {
        return this.attributeQuoteChar + s2 + this.attributeQuoteChar;
    }

    protected String substitutedAttribute(String s2) {
        String substituted = Util.substituteStandardEntities(s2);
        if (!this.showDoctypeDeclaration.booleanValue()) {
            return this.attributeQuoted(substituted);
        }
        int split = Util.splitNamespaceXML(substituted);
        String namespace2 = substituted.substring(0, split);
        String prefix = this.modelPrefixMapping.getNsURIPrefix(namespace2);
        return prefix == null || this.isPredefinedEntityName(prefix) ? this.attributeQuoted(substituted) : this.attributeQuoted("&" + this.strForPrefix(prefix) + ";" + substituted.substring(split));
    }

    private void generateDoctypeDeclaration(Model model, PrintWriter pw) {
        String rdfns = RDF.getURI();
        String rdfRDF = model.qnameFor(rdfns + "RDF");
        if (rdfRDF == null) {
            model.setNsPrefix("rdf", rdfns);
            rdfRDF = "rdf:RDF";
        }
        Map<String, String> prefixes = model.getNsPrefixMap();
        pw.print("<!DOCTYPE " + rdfRDF + " [");
        for (String prefix : prefixes.keySet()) {
            if (this.isPredefinedEntityName(prefix)) continue;
            pw.print(newline + "  <!ENTITY " + this.strForPrefix(prefix) + " '" + Util.substituteEntitiesInEntityValue(prefixes.get(prefix)) + "'>");
        }
        pw.print("]>" + newline);
    }

    private String strForPrefix(String prefix) {
        if (prefix.length() == 0) {
            return this.defaultNSEntityName;
        }
        return prefix;
    }

    private static boolean usesPrefix(Model model, String prefix) {
        return model.getNsPrefixURI(prefix) != null;
    }

    private void writeXMLDeclaration(Writer out, PrintWriter pw) {
        String javaEnc;
        String decl = null;
        if (out instanceof OutputStreamWriter && !(javaEnc = ((OutputStreamWriter)out).getEncoding()).equals("UTF8") && !javaEnc.equals("UTF-16")) {
            CharEncoding encodingInfo = CharEncoding.create(javaEnc);
            String ianaEnc = encodingInfo.name();
            decl = "<?xml version=" + this.attributeQuoted("1.0") + " encoding=" + this.attributeQuoted(ianaEnc) + "?>";
            if (!encodingInfo.isIANA()) {
                logger.warn(encodingInfo.warningMessage() + "\n   It is better to use a FileOutputStream, in place of a FileWriter.");
            }
        }
        if (decl == null && this.showXmlDeclaration != null) {
            decl = "<?xml version=" + this.attributeQuoted("1.0") + "?>";
        }
        if (decl != null) {
            pw.println(decl);
        }
    }

    @Override
    public synchronized RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler rslt = this.errorHandler;
        if (rslt == defaultErrorHandler) {
            rslt = null;
        }
        this.errorHandler = errHandler == null ? defaultErrorHandler : errHandler;
        return rslt;
    }

    private static String escapedId(String id) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < id.length(); ++i) {
            char ch = id.charAt(i);
            if (ch != 'X' && (i == 0 ? XMLChar.isNCNameStart(ch) : XMLChar.isNCName(ch))) {
                result.append(ch);
                continue;
            }
            BaseXMLWriter.escape(result, ch);
        }
        return result.toString();
    }

    private static void escape(StringBuffer sb, char ch) {
        sb.append('X');
        int charcode = ch;
        do {
            sb.append(hexchar[charcode & 0xF]);
        } while ((charcode >>= 4) != 0);
        sb.append('X');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized Object setProperty(String propName, Object propValue) {
        if (propName.equalsIgnoreCase("showXmlDeclaration")) {
            return this.setShowXmlDeclaration(propValue);
        }
        if (propName.equalsIgnoreCase("showDoctypeDeclaration")) {
            return this.setShowDoctypeDeclaration(propValue);
        }
        if (propName.equalsIgnoreCase("minimalPrefixes")) {
            Boolean bl;
            try {
                bl = !this.writingAllModelPrefixNamespaces;
            }
            catch (Throwable throwable) {
                this.writingAllModelPrefixNamespaces = !BaseXMLWriter.getBoolean(propValue);
                throw throwable;
            }
            this.writingAllModelPrefixNamespaces = !BaseXMLWriter.getBoolean(propValue);
            return bl;
        }
        if (propName.equalsIgnoreCase("xmlbase")) {
            String result = this.xmlBase;
            this.xmlBase = (String)propValue;
            return result;
        }
        if (propName.equalsIgnoreCase("tab")) {
            return this.setTab(propValue);
        }
        if (propName.equalsIgnoreCase("width")) {
            return this.setWidth(propValue);
        }
        if (propName.equalsIgnoreCase("longid")) {
            Boolean result = this.longId;
            this.longId = BaseXMLWriter.getBoolean(propValue);
            return result;
        }
        if (propName.equalsIgnoreCase("attributeQuoteChar")) {
            return this.setAttributeQuoteChar(propValue);
        }
        if (propName.equalsIgnoreCase("allowBadURIs")) {
            Boolean result = !this.demandGoodURIs;
            this.demandGoodURIs = !BaseXMLWriter.getBoolean(propValue);
            return result;
        }
        if (propName.equalsIgnoreCase("prettyTypes")) {
            return this.setTypes((Resource[])propValue);
        }
        if (propName.equalsIgnoreCase("relativeURIs")) {
            int old = this.relativeFlags;
            this.relativeFlags = BaseXMLWriter.str2flags((String)propValue);
            return BaseXMLWriter.flags2str(old);
        }
        if (propName.equalsIgnoreCase("blockRules")) {
            return this.setBlockRules(propValue);
        }
        logger.warn("Unsupported property: " + propName);
        return null;
    }

    private String setAttributeQuoteChar(Object propValue) {
        String oldValue = this.attributeQuoteChar;
        if ("\"".equals(propValue) || "'".equals(propValue)) {
            this.attributeQuoteChar = (String)propValue;
        } else {
            logger.warn("attributeQutpeChar must be either \"\\\"\" or ', not \"" + propValue + "\"");
        }
        return oldValue;
    }

    private Integer setWidth(Object propValue) {
        Integer oldValue = this.width;
        if (propValue instanceof Integer) {
            this.width = (Integer)propValue;
        } else {
            try {
                this.width = Integer.parseInt((String)propValue);
            }
            catch (Exception e2) {
                logger.warn("Bad value for width: '" + propValue + "' [" + e2.getMessage() + "]");
            }
        }
        return oldValue;
    }

    private Integer setTab(Object propValue) {
        Integer result = this.tabSize;
        if (propValue instanceof Integer) {
            this.tabSize = (Integer)propValue;
        } else {
            try {
                this.tabSize = Integer.parseInt((String)propValue);
            }
            catch (Exception e2) {
                logger.warn("Bad value for tab: '" + propValue + "' [" + e2.getMessage() + "]");
            }
        }
        return result;
    }

    private String setShowDoctypeDeclaration(Object propValue) {
        String oldValue = this.showDoctypeDeclaration.toString();
        this.showDoctypeDeclaration = BaseXMLWriter.getBooleanValue(propValue, Boolean.FALSE);
        return oldValue;
    }

    private String setShowXmlDeclaration(Object propValue) {
        String oldValue = this.showXmlDeclaration == null ? null : this.showXmlDeclaration.toString();
        this.showXmlDeclaration = BaseXMLWriter.getBooleanValue(propValue, null);
        return oldValue;
    }

    private static boolean getBoolean(Object o) {
        return BaseXMLWriter.getBooleanValue(o, Boolean.FALSE);
    }

    private static Boolean getBooleanValue(Object propValue, Boolean theDefault) {
        if (propValue == null) {
            return theDefault;
        }
        if (propValue instanceof Boolean) {
            return (Boolean)propValue;
        }
        if (propValue instanceof String) {
            return BaseXMLWriter.stringToBoolean((String)propValue, theDefault);
        }
        throw new JenaException("cannot treat as boolean: " + propValue);
    }

    private static Boolean stringToBoolean(String b, Boolean theDefault) {
        if (b.equals("default")) {
            return theDefault;
        }
        if (b.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (b.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        throw new BadBooleanException(b);
    }

    Resource[] setTypes(Resource[] x) {
        logger.warn("prettyTypes is not a property on the Basic RDF/XML writer.");
        return null;
    }

    Resource[] setBlockRules(Object o) {
        Resource[] rslt = this.blockedRules;
        this.unblockAll();
        if (o instanceof Resource[]) {
            this.blockedRules = (Resource[])o;
        } else {
            StringTokenizer tkn = new StringTokenizer((String)o, ", ");
            Vector<ResourceImpl> v = new Vector<ResourceImpl>();
            while (tkn.hasMoreElements()) {
                String frag = tkn.nextToken();
                v.add(new ResourceImpl(RDFSyntax.getURI() + frag));
            }
            this.blockedRules = new Resource[v.size()];
            v.copyInto(this.blockedRules);
        }
        for (Resource blockedRule : this.blockedRules) {
            this.blockRule(blockedRule);
        }
        return rslt;
    }

    protected String relativize(String uri) {
        return this.relativeFlags != 0 && this.baseURI != null ? this.relativize(this.baseURI, uri) : this.checkURI(uri);
    }

    private String relativize(IRI base, String uri) {
        return base.relativize(uri, this.relativeFlags).toString();
    }

    private String checkURI(String uri) {
        IRI iri;
        if (this.demandGoodURIs && (iri = factory.create(uri)).hasViolation(false)) {
            throw new BadURIException("Only well-formed absolute URIrefs can be included in RDF/XML output: " + iri.violations(false).next().getShortMessage());
        }
        return uri;
    }

    private boolean checkLegalPrefix(String prefix) {
        if (prefix.equals("")) {
            return true;
        }
        if (prefix.toLowerCase().startsWith("xml")) {
            logger.warn("Namespace prefix '" + prefix + "' is reserved by XML.");
        } else if (!XMLChar.isValidNCName(prefix)) {
            logger.warn("'" + prefix + "' is not a legal namespace prefix.");
        } else if (jenaNamespace.matcher(prefix).matches()) {
            logger.warn("Namespace prefix '" + prefix + "' is reserved by Jena.");
        } else {
            return true;
        }
        return false;
    }

    private static String flags2str(int f) {
        StringBuffer oldValue = new StringBuffer(64);
        if ((f & 1) != 0) {
            oldValue.append("same-document, ");
        }
        if ((f & 2) != 0) {
            oldValue.append("network, ");
        }
        if ((f & 4) != 0) {
            oldValue.append("absolute, ");
        }
        if ((f & 8) != 0) {
            oldValue.append("relative, ");
        }
        if ((f & 0x10) != 0) {
            oldValue.append("parent, ");
        }
        if ((f & 0x20) != 0) {
            oldValue.append("grandparent, ");
        }
        if (oldValue.length() > 0) {
            oldValue.setLength(oldValue.length() - 2);
        }
        return oldValue.toString();
    }

    public static int str2flags(String pv) {
        StringTokenizer tkn = new StringTokenizer(pv, ", ");
        int rslt = 0;
        while (tkn.hasMoreElements()) {
            String flag = tkn.nextToken();
            if (flag.equals("same-document")) {
                rslt |= 1;
                continue;
            }
            if (flag.equals("network")) {
                rslt |= 2;
                continue;
            }
            if (flag.equals("absolute")) {
                rslt |= 4;
                continue;
            }
            if (flag.equals("relative")) {
                rslt |= 8;
                continue;
            }
            if (flag.equals("parent")) {
                rslt |= 0x10;
                continue;
            }
            if (flag.equals("grandparent")) {
                rslt |= 0x20;
                continue;
            }
            logger.warn("Incorrect property value for relativeURIs: " + flag);
        }
        return rslt;
    }

    static {
        badRDF.add("RDF");
        badRDF.add("Description");
        badRDF.add("li");
        badRDF.add("about");
        badRDF.add("aboutEach");
        badRDF.add("aboutEachPrefix");
        badRDF.add("ID");
        badRDF.add("nodeID");
        badRDF.add("parseType");
        badRDF.add("datatype");
        badRDF.add("bagID");
        badRDF.add("resource");
        defaultErrorHandler = new RDFDefaultErrorHandler();
        factory = IRIFactory.jenaImplementation();
        predefinedEntityNames = Pattern.compile("amp|lt|gt|apos|quot");
        hexchar = "0123456789abcdef".toCharArray();
    }
}

