/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.impl;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import org.apache.jena.reasoner.rulesys.BindingEnvironment;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.util.iterator.ClosableIterator;

public class BBRuleContext
implements RuleContext {
    protected BindingEnvironment env;
    protected Rule rule;
    protected BackwardRuleInfGraphI graph;

    public BBRuleContext(BackwardRuleInfGraphI graph) {
        this.graph = graph;
    }

    @Override
    public boolean contains(Node s2, Node p, Node o) {
        ClosableIterator<Triple> i = this.find(s2, p, o);
        boolean result = i.hasNext();
        i.close();
        return result;
    }

    @Override
    public boolean contains(Triple t2) {
        return this.contains(t2.getSubject(), t2.getPredicate(), t2.getObject());
    }

    @Override
    public ClosableIterator<Triple> find(Node s2, Node p, Node o) {
        return this.graph.findDataMatches(new TriplePattern(s2, p, o));
    }

    @Override
    public BindingEnvironment getEnv() {
        return this.env;
    }

    public void setEnv(BindingEnvironment env) {
        this.env = env;
    }

    @Override
    public InfGraph getGraph() {
        return this.graph;
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public void setRule(Rule rule) {
        this.rule = rule;
    }

    @Override
    public void silentAdd(Triple t2) {
        this.graph.silentAdd(t2);
    }

    @Override
    public void add(Triple t2) {
        this.graph.silentAdd(t2);
    }

    @Override
    public void remove(Triple t2) {
        this.graph.delete(t2);
    }

    public Node getTemp(Node instance, Node prop, Node pclass) {
        return this.graph.getTemp(instance, prop, pclass);
    }
}

