/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdf.model.RDFWriterI;

public abstract class JenaWriterBase
implements RDFWriterI {
    protected Map<String, String> writerPropertyMap = new HashMap<String, String>();
    private RDFErrorHandler errorHandler = null;

    @Override
    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        return old;
    }

    @Override
    public Object setProperty(String propName, Object propValue) {
        if (!(propValue instanceof String)) {
            Log.warn(this, "setProperty: Property for '" + propName + "' is not a string");
            propValue = propValue.toString();
        }
        propName = this.absolutePropName(propName);
        if (this.writerPropertyMap == null) {
            this.writerPropertyMap = new HashMap<String, String>();
        }
        String oldValue = this.writerPropertyMap.get(propName);
        this.writerPropertyMap.put(propName, (String)propValue);
        return oldValue;
    }

    protected String absolutePropName(String propName) {
        return propName;
    }

    @Override
    public void write(Model model, Writer out, String base) {
        this.write(model.getGraph(), out, base);
    }

    @Override
    public void write(Model model, OutputStream out, String base) {
        Writer w = IO.asBufferedUTF8(out);
        this.write(model.getGraph(), w, base);
        try {
            w.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract void write(Graph var1, Writer var2, String var3);
}

